
#include "WANOT.h"

/*
 *  Global variables declarations
 */
 
extern SuperSlotStates SuperSlotState;

volatile MasterSetUpStates MasterSetUpState = sendBeacon;

volatile msgType messageType = msgRTS;

extern RadioEvents_t RadioEvents;
extern SX1276MB1xAS Radio;

extern uint16_t BufferSize;
extern uint8_t Buffer[];

extern uint32_t LORA_Channels[NUMBER_OF_CHANNELS];

extern int16_t RssiValue;
extern int8_t SnrValue;

extern uint8_t TDMAChannel;

static Timer timer;
static int begin, end;

void SetUp_OnTxDone(void)
{
    if(MasterSetUpState != Wait_for_JoinReq)
        Radio.Rx(RX_TIMEOUT_VALUE);
    else
        Radio.Rx(1.5 * RX_TIMEOUT_VALUE);
    debug("OnTxDone!!\n\r");

}

void SetUp_OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep();
    BufferSize = size;
    memcpy(Buffer, payload, BufferSize);
    RssiValue = rssi;
    SnrValue = snr;

    debug("OnRxDone!!\n\r");

    switch (MasterSetUpState) {
        case Wait_for_RTS:
            messageType = msgRTS;
            if (messageType == Buffer[0]) {
                MasterSetUpState = Send_CTS;
                debug("RTS Packet\n\r");
            } else {
                MasterSetUpState = sendBeacon;
                debug("RTS Packet Mismatch\n\r");
            }
            break;

        case Wait_for_JoinReq:
            messageType = msgJoinReq;
            if (messageType == Buffer[0]) {
                MasterSetUpState = Send_JoinAccept;
                debug("JoinReq Packet\n\r");
            } else {
                MasterSetUpState = sendBeacon;
                debug("JoinReq Packet Mismatch\n\r");
            }
            break;

        case Wait_for_Ack:
            messageType = msgAck;
            if (messageType == Buffer[0]) {
                MasterSetUpState = AckDone;
                debug("Ack Packet\n\r");
            } else {
                MasterSetUpState = sendBeacon;
                debug("Ack Packet Mistmatch\n\r");

            }
            break;

        default:
            break;
    }


}



void SetUp_OnTxTimeout(void)
{

}

void SetUp_OnRxTimeout(void)
{
    MasterSetUpState = sendBeacon;
    debug("OnRxTimeout!!\n\r");

}

void SetUp_OnRxError(void)
{
    MasterSetUpState = sendBeacon;
}

void MasterSetUp()
{
    debug("Master Set Up Phase Started...\n\r");
    
    timer.start();
    begin = timer.read_us();
    
    // Initialize Radio driver
    RadioEvents.TxDone = SetUp_OnTxDone;
    RadioEvents.RxDone = SetUp_OnRxDone;
    RadioEvents.RxError = SetUp_OnRxError;
    RadioEvents.TxTimeout = SetUp_OnTxTimeout;
    RadioEvents.RxTimeout = SetUp_OnRxTimeout;
    Radio.Init(&RadioEvents);
    
    uint8_t Beacon_Counter = 0;

    while (SuperSlotState == SetUp_Phase) {
        switch (MasterSetUpState) {
            case sendBeacon:
                if(Beacon_Counter <=4) {
                    Beacon_Counter++;
                    Buffer[0] = SETUP_BEACON_SYNCWORD;
                    Radio.Send(Buffer, BUFFER_SIZE_RTS);
                    debug("Sending Beacon\n\r");
                    MasterSetUpState = Wait_for_RTS;
                } else {
                    debug("Beacon Timed Out without SLaves\n\r");
                    MasterSetUpState = Slave_Not_Found;
                    Beacon_Counter = 0;
                }
                break;

            case Send_CTS:
                messageType = msgCTS;
                Buffer[0] = messageType;
                Buffer[1] = SnrValue;
                Radio.Send(Buffer, BUFFER_SIZE_CTS);
                debug("Sending CTS\n\r");
                MasterSetUpState = Wait_for_JoinReq;
                break;

            case Send_JoinAccept:
                messageType = msgJoinAccept;
                Buffer[0] = messageType;
                Buffer[11] = 5;
                Radio.Send(Buffer, BUFFER_SIZE_JoinAccept);
                debug("Sending JoinAccept\n\r");
                MasterSetUpState = Wait_for_Ack;
                break;

            case AckDone:
                debug("Ack done: +1 \n\r");
                MasterSetUpState = sendBeacon;
                end = timer.read_us();
                debug("Registeration took : %f S\n\r", (end-begin)/1000000.0);
                break;

            case Slave_Not_Found:
                debug("Slave Not Found .. Sleep");
                Radio.Sleep();
                MasterSetUpState = sendBeacon;
                break;

            case Wait_for_Ack:
            case Wait_for_RTS:
            case Wait_for_JoinReq:
                break;
            default:
                break;

        }

    }
    debug("Master Set Up Phase Finished...\n\r");
}