

#include "mbed.h"
#include "x_cube_mems.h"

DigitalOut led(LED1);

Serial pc(USBTX, USBRX);

Ticker blinky; 
Ticker update;

volatile float TEMPERATURE_C;
volatile float TEMPERATURE_F;
volatile float TEMPERATURE_K;
volatile float HUMIDITY;
volatile float PRESSURE;

bool measurements_update = false;

void blinky_handler(){
    led = !led;
}

void sensors_handler(){
    measurements_update = true;
}

int main() {
    
   
    static X_CUBE_MEMS *Sensors = X_CUBE_MEMS::Instance();
    
    
    blinky.attach(&blinky_handler, 0.5);
    update.attach(&sensors_handler, 3);
    
    while(1) {

        if(measurements_update == true){
        /* Read the environmental sensors  */
        
            <your code should be here>
            
        
        pc.printf("Temperature:\t %.2f C / %.2f F / %.2f K\r\n", TEMPERATURE_C, TEMPERATURE_F, TEMPERATURE_K);
        pc.printf("Humidity:\t %.2f%%\r\n", HUMIDITY);
    

        pc.printf("\r\n");
                
        measurements_update = false;
        }
        __wfi();
    }
}