/**
Electronically Controlled Intelligent Shelves
Developed by: Priyank Kalgaonkar
**/

#include "mbed.h"
#include "hcsr04.h"
#include "math.h"
#include "RGBLED.h"

//Setup RGB led using PWM pins and class
RGBLed myRGBled(D6,D5,D3); //RGB PWM pins

DigitalIn sw2(SW2);
DigitalOut RLed(LED1);                      //Onboard Red LED = Shelf Out of Stock
DigitalOut GLed(LED2);                      //Onboard Green LED = All OK
DigitalOut BLed(LED3);                      //Onboard Blue LED for Wifi Tx Indication
HCSR04 usensor1(D8,D9);                     //ECHO Pin=D9, TRIG Pin=D8
Serial pc(USBTX,USBRX);                     //Serial Communication with PC


void wifi_send(void);;                      //Connect and Push Data Channel to Cloud Server

int num = 0;
int distance1, distance2;
float dist_remaining1, dist_percent1, dist_remaining2, dist_percent2;
char snd[255],rcv[1000];                    //snd: send command to ESP8266
                                            //rcv: receive response from ESP8266

int main()
{
    pc.baud(115200);                        //Baud Rate of 115200 for Tera Term

    pc.printf("Initial Setup\r\n");
 
    while(num<1000000000000)
    {
        num=num+1;
    //checking for switch value to detect traffic light 
        if(sw2 == 0) {
        myRGBled.write(1.0,0.0,0.0); //red
        printf("Red light detected; applying breaks\n\r");
        wait(1.0);
        }else{
     myRGBled.write(0.0,1.0,0.0); //green
        
    //Ultrasound Sensor (HC-SR04) #1 Initialization
        usensor1.start();
        wait_ms(500);
        
    //Calculating Distance for Sensor # 1
        distance1 = usensor1.get_dist_cm();

    //LED and Tera Term Output
            if (distance1<10) {
                RLed = 1;
                BLed = 0;
                GLed = 0;
                printf("Emergency Brakes Engaged %u\n\r", distance1);
                wait(1.0);
            } else {
                GLed = 1;
                BLed = 0;
                RLed = 0;
                printf("Distance: %u\n\r", distance1); 
            }    //end nested-if
        }   //end if
    }   //end while
}   //end main