#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
DigitalIn sd_cs(PTA16);
Serial pc(USBTX, USBRX);
FILE *fp;

uint32_t do_list(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    uint32_t counter = 0;

    while ((p = readdir(d)) != NULL) {
        counter++;
        printf("%s\n", p->d_name);
    }
    closedir(d);
    return counter;
}

int main()
{
    pc.printf("Initializing \n\r");
    wait(1);
    pc.printf("Opening nyah/nyoho.txt\n\r");

    wait(1);
    fp = fopen("/sd/nyah/nyoho.txt", "r+");

    if (fp == NULL) {
        pc.printf("Unable to open the file \r\n");
    } else {
        pc.printf("\n\rFile pointer address: 0x%X\n\r", &fp);
        
        pc.printf("\n\rWriting to nyah/nyoho.txt\n\r");
        wait(0.25);

        fprintf(fp, "The quick brown fox jumps over the lazy dog");

        rewind(fp);
        fprintf(fp, "Seiya is trying to eat the SD card please stop him");
        wait(0.25);

        pc.printf("\n\rFlushing the buffer...\n\r");
        int flush = fflush(fp);
        wait(0.25);
        if (flush == 0) pc.printf("Flush Successful!\n\r");
        else pc.printf("**WARNING** Flush Failed\n\r");
    }
    wait(1);
    fclose(fp);
    pc.printf("\n\rDone\r\n");
    wait(1);
    exit(3);
}