#include "mbed.h"

DigitalOut led1(PTC5);

DigitalOut leds[5]  = { PTE6, PTE5, PTE4 ,PTE3, PTE2 };
int        power[5] = {    0,   25,   50,   75,  100 };

DigitalOut m1(PTA5);
PwmOut     pwm1(PTA13);
AnalogIn   fb1(PTB2);

Serial     pc(USBTX, USBRX);

void setMotor(int p)
{
    pc.printf("Motor at %d%% power\n\r", p);
    pwm1.write(p);
}

int main()
{
    pc.printf("Starting Active System test...\n\r");
    wait(0.5);
    pwm1.period(4.0f);

    while (true) {
        pc.printf("----  Forward Test  ----\n\r");
        led1 = 1;
        m1 = 0;
        for ( int i = 0; i < 5; i++ ) {
            setMotor(power[i]);
            leds[i] = 1;
            printf("Current Reading: %f\n\r", fb1);
            wait(1);
            leds[i] = 0;
        }

        pc.printf("---- Backwards Test ----\n\r");
        led1 = 0;
        m1 = 1;
        for ( int i = 0; i < 5; i++ ) {
            setMotor(power[i]);
            leds[i] = 1;
            printf("Current Reading: %f\n\r", fb1);
            wait(1);
            leds[i] = 0;
        }
    }
}