#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "SMTPClient.h"

#define HOSTNAME "mbedSE"

// server is domain name eg. mail.authsmtp.com
// port is smtp port eg. 25 or 23
// domain must be acceptable to server (but often is not strictly enforced since does not affect FROM address)
#define SERVER "server"
#define PORT 25
#define USER "username"
#define PASSWORD "password"
#define DOMAIN "mailnull.com"
#define FROM_ADDRESS "segundo.smtpclient@mailnull.com"
#define TO_ADDRESS "segundo.smtpclient@mailnull.com"

EthernetNetIf eth(HOSTNAME);
DigitalOut led1(LED1, "led1");

int main() {

    printf("\n\n/* Segundo Equipo SMTPClient library demonstration */\n");
    printf("Make sure you have modified the SERVER, PORT etc in the source code\n");
    
    EthernetErr ethErr;
    int count = 0;
    do {
        printf("Setting up %d...\n", ++count);
        ethErr = eth.setup();
        if (ethErr) printf("Timeout\n", ethErr);
    } while (ethErr != ETH_OK);

    printf("Connected OK\n");
    const char* hwAddr = eth.getHwAddr();
    printf("HW address : %02x:%02x:%02x:%02x:%02x:%02x\n",
           hwAddr[0], hwAddr[1], hwAddr[2],
           hwAddr[3], hwAddr[4], hwAddr[5]);

    IpAddr ethIp = eth.getIp();
    printf("IP address : %d.%d.%d.%d\n", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);

    NTPClient ntp;
    printf("NTP setTime...\n");
    Host server(IpAddr(), 123, "pool.ntp.org");
    printf("Result : %d\n", ntp.setTime(server));

    time_t ctTime = time(NULL);
    printf("\nTime is now (UTC): %d %s\n", ctTime, ctime(&ctTime));

    Host host(IpAddr(), PORT, SERVER);
    SMTPClient smtp(host, DOMAIN, USER, PASSWORD, SMTP_AUTH_PLAIN);
    
    EmailMessage msg;
    msg.setFrom(FROM_ADDRESS);
    msg.addTo(TO_ADDRESS);
    msg.printf("Subject: mbed SMTPClient test at %s", ctime(&ctTime));
    msg.printf("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n");
    msg.printf(".\r\n");
    msg.printf("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n");

    printf("Send result %d\n", smtp.send(&msg));
    printf("Last response | %s", smtp.getLastResponse().c_str());

    Timer tm;
    tm.start();

    while (true) {
        if (tm.read() > 0.5) {
            led1 = !led1;
            tm.start();
        }
    }
}