#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

#define HOSTNAME "mbedSE"

EthernetNetIf eth(HOSTNAME);
HTTPClient http;
NTPClient ntp;
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

void DoEcho(char* input, char* output);
RPCFunction Echo(&DoEcho, "echo");

void DoEcho(char* input, char* output) {
    printf("%s\n", input);
    strcpy(output, input);
}

int main() {

    printf("\n\n/* Segundo Equipo NetServices library demonstration */\n");
    printf("Try starting the program with the network disconnected and then connect after a few timeouts reported\n\n");
    EthernetErr ethErr;
    int count = 0;
    do {
        printf("Setting up %d...\n", ++count);
        ethErr = eth.setup();
        if (ethErr) printf("Timeout\n", ethErr);
    } while (ethErr != ETH_OK);

    printf("Connected OK\n");
    const char* hwAddr = eth.getHwAddr();
    printf("HW address : %02x:%02x:%02x:%02x:%02x:%02x\n",
           hwAddr[0], hwAddr[1], hwAddr[2],
           hwAddr[3], hwAddr[4], hwAddr[5]);

    IpAddr ethIp = eth.getIp();
    printf("IP address : %d.%d.%d.%d\n", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    printf("Check router DHCP table for name : %s\n", eth.getHostname());

    printf("\nHTTPClient get...\n");
    HTTPText txt;
    HTTPResult r = http.get("http://mbed.org/media/uploads/donatien/hello.txt", &txt);
    if (r==HTTP_OK) {
        printf("Result ok : %s\n", txt.gets());
    } else {
        printf("Error %d\n", r);
    }

    time_t ctTime;
    ctTime = time(NULL);
    printf("\nCurrent time is (UTC): %d %s\n", ctTime, ctime(&ctTime));
    printf("NTP setTime...\n");
    Host server(IpAddr(), 123, "pool.ntp.org");
    printf("Result : %d\n", ntp.setTime(server));

    ctTime = time(NULL);
    printf("\nTime is now (UTC): %d %s\n", ctTime, ctime(&ctTime));

    printf("NTP setTime to a deliberately incorrect server...\n");
    server.setName("www.google.com");
    printf("Result : %d\n", ntp.setTime(server));

    ctTime = time(NULL);
    printf("\nTime should still be correct (UTC): %d %s\n", ctTime, ctime(&ctTime));
    
    char ip[16];
    sprintf(ip, "%d.%d.%d.%d", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    
#define PORT 80
    svr.addHandler<RPCHandler>("/rpc");
    svr.bind(PORT);
    printf("Server listening (port %d)\n", PORT);
    printf("- LED1 should flash\n");
    printf("- type into browser to test url decode : %s/rpc/echo/run \"quoted string with <>\" or http://192.168.1.103/rpc/echo/run%%20%%22quoted%%20string%%20with%%20%%3C%%3E%%22\n", ip);

    Timer tm;
    tm.start();

    while (true) {
        Net::poll();
        if (tm.read() > 0.5) {
            led1 = !led1;
            tm.start();
        }
    }
}