#include "mbed.h"
#include "7SegSRDriver.h"

/***********************************************            CHRONOMETRE               ****************************************************************/
SSegSRDriver_chronometre::SSegSRDriver_chronometre(PinName srData, PinName srClock, PinName srLatch, bool disp_type): _srData(srData), _srClock(srClock), _srLatch(srLatch) {
    _disp_type = disp_type;
    bus_chronometre_1(0);
    bus_chronometre_2(0);
    bus_chronometre_3(0);
    bus_chronometre_4(0);    
}

void SSegSRDriver_chronometre::clear() {
    bus_chronometre_1(0);
    bus_chronometre_2(0);
    bus_chronometre_3(0);
    bus_chronometre_4(0); 
}

void SSegSRDriver_chronometre::write_chronometre(unsigned char number, bool dp) {
    if (number<10) {
        bus_chronometre_1((nbr_envoye[number] << 1) | dp);
    }
}

void SSegSRDriver_chronometre::write_chronometre_2(unsigned char number, bool dp) {
    if (number<10) {
        bus_chronometre_2((nbr_envoye_2[number] << 1) | dp);
    }
}

void SSegSRDriver_chronometre::write_chronometre_3(unsigned char number, bool dp) {
    if (number<10) {
        bus_chronometre_3((nbr_envoye_3[number] << 1) | dp);
    }
}

void SSegSRDriver_chronometre::write_chronometre_4(unsigned char number, bool dp) {
    if (number<10) {
        bus_chronometre_3((nbr_envoye_4[number] << 1) | dp);
    }
}

void SSegSRDriver_chronometre::bus_chronometre_1(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
 }   
    
void SSegSRDriver_chronometre::bus_chronometre_2(unsigned char Value) 
{

    if (Value<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) // on parcours l'octet 
        {    
            _srClock = 0;
            _srData = (Value & (1<<i)); //décoposition de l'octet 
            _srClock = 1;
        }   
        _srLatch = 1;
        _srData = 0;
}
 }  
 
 void SSegSRDriver_chronometre::bus_chronometre_3(unsigned char Value) 
{

    if (Value<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) // on parcours l'octet 
        {    
            _srClock = 0;
            _srData = (Value & (1<<i)); //décoposition de l'octet 
            _srClock = 1;
        }   
        _srLatch = 1;
        _srData = 0;
}
 } 
 
 void SSegSRDriver_chronometre::bus_chronometre_4(unsigned char Value) 
{

    if (Value<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) // on parcours l'octet 
        {    
            _srClock = 0;
            _srData = (Value & (1<<i)); //décoposition de l'octet 
            _srClock = 1;
        }   
        _srLatch = 1;
        _srData = 0;
}
 } 
 
 
 /***********************************************            DOMICILE                ****************************************************************/
 
SSegSRDriver_domicile::SSegSRDriver_domicile(PinName srData, PinName srClock, PinName srLatch, bool disp_type): _srData(srData), _srClock(srClock), _srLatch(srLatch) {
    _disp_type = disp_type;
    bus_domicile_1(0);
    bus_domicile_2(0);
    bus_domicile_3(0);  
}

void SSegSRDriver_domicile::clear() {
    bus_domicile_1(0);
    bus_domicile_2(0);
    bus_domicile_3(0);
}

void SSegSRDriver_domicile::write_domicile(unsigned char number, bool dp) {
    if (number<10) {
        bus_domicile_1((nbr_envoye[number] << 1) | dp);
    }
}

void SSegSRDriver_domicile::write_domicile_2(unsigned char number, bool dp) {
    if (number<10) {
        bus_domicile_2((nbr_envoye_2[number] << 1) | dp);
    }
}

void SSegSRDriver_domicile::write_domicile_3(unsigned char number, bool dp) {
    if (number<10) {
        bus_domicile_3((nbr_envoye_3[number] << 1) | dp);
    }
}

void SSegSRDriver_domicile::bus_domicile_1(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
 }  
 
void SSegSRDriver_domicile::bus_domicile_2(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
 } 
 
void SSegSRDriver_domicile::bus_domicile_3(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
}

 
 /***********************************************            VISITEUR               ****************************************************************/
 
SSegSRDriver_visiteur::SSegSRDriver_visiteur(PinName srData, PinName srClock, PinName srLatch, bool disp_type): _srData(srData), _srClock(srClock), _srLatch(srLatch) {
    _disp_type = disp_type;
    bus_visiteur_1(0);
    bus_visiteur_2(0);
    bus_visiteur_3(0);  
}

void SSegSRDriver_visiteur::clear() {
    bus_visiteur_1(0);
    bus_visiteur_2(0);
    bus_visiteur_3(0);
}
 
void SSegSRDriver_visiteur::write_visiteur(unsigned char number, bool dp) {
    if (number<10) {
        bus_visiteur_1((nbr_envoye[number] << 1) | dp);
    }
}

void SSegSRDriver_visiteur::write_visiteur_2(unsigned char number, bool dp) {
    if (number<10) {
        bus_visiteur_2((nbr_envoye_2[number] << 1) | dp);
    }
}

void SSegSRDriver_visiteur::write_visiteur_3(unsigned char number, bool dp) {
    if (number<10) {
        bus_visiteur_3((nbr_envoye_3[number] << 1) | dp);
    }
}

void SSegSRDriver_visiteur::bus_visiteur_1(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
 }  
 
void SSegSRDriver_visiteur::bus_visiteur_2(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
 } 
 
void SSegSRDriver_visiteur::bus_visiteur_3(unsigned char Val) { // Val= les segments a éclairer  

    if (Val<=0xFF) {// Si la valeur est inférieur ou égale a 255 
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // on parcours l'octet 
            _srClock = 0;
            _srData = (Val & (1<<i)); //décoposition de l'octet en bit 
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
    
}
 