#ifndef LIB_SSEGSRDRIVER_H
#define LIB_SSEGSRDRIVER_H

#include "mbed.h"

#define SSegSRDriver_COMN_ANODE 0
#define SSegSRDriver_COMN_CATHODE 1

const unsigned char nbr_envoye[11] = {0x3f, 0x30 , 0x6d, 0x79, 0x72, 0x5b, 0x5f, 0x33, 0x7f, 0x7b, 0x00};
const unsigned char nbr_envoye_2[11] = {0x3f, 0x30 , 0x6d, 0x79, 0x72, 0x5b, 0x5f, 0x33, 0x7f, 0x7b, 0x00};
const unsigned char nbr_envoye_3[11] = {0x3f, 0x30 , 0x6d, 0x79, 0x72, 0x5b, 0x5f, 0x33, 0x7f, 0x7b, 0x00};
const unsigned char nbr_envoye_4[11] = {0x3f, 0x30 , 0x6d, 0x79, 0x72, 0x5b, 0x5f, 0x33, 0x7f, 0x7b, 0x00};


/**************************************************                 CHRONOMETRE                   ****************************************************/


class SSegSRDriver_chronometre {

public:

    SSegSRDriver_chronometre(PinName srData, PinName srClock, PinName srLatch, bool disp_type);
    void write_chronometre(unsigned char number, bool dp);   
    void write_chronometre_2(unsigned char number_deux, bool dp); //
    void write_chronometre_3(unsigned char number_trois, bool dp);
    void write_chronometre_4(unsigned char number_quatre, bool dp);
    
    void bus_chronometre_1(unsigned char number);   // inustruction pour le bus 1 de 0 a 8 bit 
    void bus_chronometre_2(unsigned char number_deux);   // inustruction pour le bus 2 de 0 a 8 bit
    void bus_chronometre_3(unsigned char number_trois);
    void bus_chronometre_4(unsigned char number_quatre); 
    void clear();  
    
private:

    DigitalOut _srData;
    DigitalOut _srClock;
    DigitalOut _srLatch;
    bool _disp_type;
};


/**************************************************                 DOMICILE                   ****************************************************/


class SSegSRDriver_domicile {

public:

    SSegSRDriver_domicile(PinName srData, PinName srClock, PinName srLatch, bool disp_type);

    void set_type(bool disp_type);
    void write_domicile(unsigned char number, bool dp);   
    void write_domicile_2(unsigned char number_deux, bool dp); 
    void write_domicile_3(unsigned char number_trois, bool dp);
    
    void bus_domicile_1(unsigned char number);   // inustruction pour le bus 1 de 0 a 8 bit 
    void bus_domicile_2(unsigned char number_deux);   // inustruction pour le bus 2 de 0 a 8 bit
    void bus_domicile_3(unsigned char number_trois); 
    void clear();  
    
private:

    DigitalOut _srData;
    DigitalOut _srClock;
    DigitalOut _srLatch;
    bool _disp_type;
};


/**************************************************                 VISITEUR                   ****************************************************/


class SSegSRDriver_visiteur {

public:

    SSegSRDriver_visiteur(PinName srData, PinName srClock, PinName srLatch, bool disp_type);

    void set_type(bool disp_type);
    void write_visiteur(unsigned char number, bool dp);   
    void write_visiteur_2(unsigned char number_deux, bool dp); 
    void write_visiteur_3(unsigned char number_trois, bool dp);
    
    void bus_visiteur_1(unsigned char number);   // inustruction pour le bus 1 de 0 a 8 bit 
    void bus_visiteur_2(unsigned char number_deux);   // inustruction pour le bus 2 de 0 a 8 bit
    void bus_visiteur_3(unsigned char number_trois); 
    void clear();  
    
private:

    DigitalOut _srData;
    DigitalOut _srClock;
    DigitalOut _srLatch;
    bool _disp_type;
};

#endif