#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "Time.h"

C12832_LCD lcd; //Graphics LCD
 /*****************MAISON*****************/
/*const char* ip= "192.168.1.49";
const char* masque= "255.255.255.0";
const char* gateway= "192.168.1.254";*/

/*****************COUR*******************/
const char* ip= "172.16.202.4";
const char* masque= "255.255.0.0";
const char* gateway= "172.16.0.5";

const int MCAST_PORT = 8888;

Timer heure;

int main() {
    /************HEURE********************/
    EthernetInterface eth;
    eth.init(ip,masque,gateway); //Use DHCP
    eth.connect();
    
    UDPSocket sock;
    sock.init();

    Endpoint nist;
    nist.set_address("utcnist.colorado.edu", 37);

    char out_buffer[] = ""; // Does not matter
    sock.sendTo(nist, out_buffer, sizeof(out_buffer));
   
    
    char in_buffer[4];
    int n = sock.receiveFrom(nist, in_buffer, sizeof(in_buffer)); 
    unsigned int timeRes = ntohl( *((unsigned int*)in_buffer));
  /************PREMIER SERVEUR ********************/
    UDPSocket server;
    server.bind(MCAST_PORT);
    Endpoint client;
    char data[256];

    int heure01;
    int heure02;
    
    int minute01;
    int minute02;
while (true)
{
           heure.start();
    data[0] = 0;
    server.receiveFrom(client, data, sizeof(data));   

if(data[0]=='B' && data[1]=='U' && data[2] =='Z'  && data[3] == 'Z')
{
     lcd.cls();
     lcd.printf("premier serveur !");
}

if(data[0]=='B' && data[1]=='A' && data[2] =='C'  && data[3] == 'K')
{
        //lcd.cls();
        //lcd.printf("premier serveur22");
        if (heure.read_ms()  >= 1000 )
        {
            set_time(timeRes);
            time_t unixTime= time(NULL);
            TimeStamp timeStamp(unixTime);
            lcd.cls();
            lcd.locate(1, 0);
           // lcd.printf("heure :%d ------ minute :%d ",timeStamp.getHour()+2,timeStamp.getMinute());
           
                   heure01= ((timeStamp.getHour()+2) /10);
                   heure02= ((timeStamp.getHour()+2) %10);
                   
                   minute01= ((timeStamp.getMinute()) /10);
                   minute02= ((timeStamp.getMinute()) %10);
                
            
            lcd.printf("heure1 :%d ------ heure2 :%d", heure01, heure02);
            lcd.printf("\n");
            lcd.printf("minute1 :%d ------ minute2 :%d", minute01, minute02);
            lcd.printf("\n");
            lcd.printf("%d",heure.read_ms());
            timeRes+=1;
            heure.reset();
    
        }
    }
}


}
