#include "mbed.h"
#include "7SegSRDriver.h"
#include "EthernetInterface.h"
#include "Time.h"
#include "C12832_lcd.h"

//#include "C12832.h"


#include "NetworkAPI/buffer.hpp"
#include "NetworkAPI/ip/address.hpp"
#include "NetworkAPI/udp/socket.hpp"

DigitalOut Buzzer(p6);

const char* MCAST_GRP = "224.1.1.1";
const int MCAST_PORT = 8888;

const char* ip= "172.16.202.4";
const char* masque= "255.255.0.0";
const char* gateway= "172.16.0.5";

Timer t;

SSegSRDriver_chronometre display(p26,p7,p25, SSegSRDriver_COMN_CATHODE); //data , clock, latch    // Chrono
SSegSRDriver_domicile display2(p23,p7,p24, SSegSRDriver_COMN_CATHODE); //data , clock, latch    // Visiteur 
SSegSRDriver_visiteur display3(p21,p7,p22, SSegSRDriver_COMN_CATHODE); //data , clock, latch    // domicile




//C12832 lcd(p5, p7, p6, p8, p11); //le mod d'affichage 
/*************************AFFICHE DOMICILE*************************************/    
void afficherDOM(SSegSRDriver_domicile display2, int centaine, int dizaine, int unite)
{
        display2.write_domicile(centaine,0);//C
        display2.write_domicile_2(dizaine,0);//D
        display2.write_domicile_3(unite,0);//U  
}
/*************************AFFICHE VISITEUR*************************************/ 
void afficherVIS(SSegSRDriver_visiteur display3, int centaine, int dizaine, int unite)
{
        display3.write_visiteur(centaine,0);//C
        display3.write_visiteur_2(dizaine,0);//D
        display3.write_visiteur_3(unite,0);//U  
}
/*************************AFFICHE CHRONOMETRE**********************************/ 
void affiche_chrono(SSegSRDriver_chronometre display,int unite, int dizaine, int centaine,int millier) 
{
        display.write_chronometre_4(millier,0); 
        display.write_chronometre_3(centaine,0);
        display.write_chronometre_2(dizaine,0);
        display.write_chronometre(unite,0); // le 0 c'est le dp il es tjf off
}

/*************************CALCULE INCREMENTE***********************************/ 
void calculIncremente(int* centaine, int* dizaine, int* unite) 
{ 
    if((*unite) >=10)
    {
        (*unite)=(*unite)-10;
        ((*dizaine))++;
    }
    if(((*dizaine)) >=10)
    {
        ((*dizaine))-=10;
        ((*centaine))++;
    }
}       
/*************************CALCULE DECREMENTE***********************************/ 
void calculDecremente(int* centaine, int* dizaine, int* unite)
{
    if((*unite)<0)  //si l'unité est inférieur a 0
    {
        (*unite) +=10; // unité sera égale a 10
        if((*dizaine) == 0) // si la dizaine est égale a 0
        {
            if((*centaine) > 0)// et la centaine est suppérieur a 0
            {
                (*centaine) -= 1; //centaine sera égale a centaine -1
                (*dizaine) = 9; // dizaine sera égale a 9
            }
        } 
        else //si la dizaine ne sera pas égale a 0
        {
            (*dizaine) -=1; //dizaine sera égale a dizaine -1
        }
    }
}
/*************************PLAY CHRONOMETRE*************************************/ 
void playchrono(SSegSRDriver_chronometre display, int* unite, int* dizaine, int* centaine,int* millier)
{
    t.start();
    if (t.read_ms() >= 1000)
    {

    if ((*unite) >= 10) //si unité seconde suppérieur ou égale a 9 
        {
            (*dizaine)++;     //dizaine seconde sera égale a dizaine seconde +1 
            (*unite) =0;    //unité seconde sera égale a  0
        }
        if ((*dizaine) >= 6)  //si dizaine seconde suppérieur ou égale a 6 (60secondes) 
        {
                (*dizaine) =0;    //dizaine seconde sera égale a 0
                (*unite) =0;    //unité seconde sera égale a 0
                (*centaine) ++;    //unité minute sera égale a unité minute +1
        }
        if ((*centaine) >= 10)
        {
                (*centaine)=0;
                (*millier)++;  
        }       
        display.write_chronometre_4(*millier,0); 
        display.write_chronometre_3(*centaine,0);
        display.write_chronometre_2(*dizaine,0);
        display.write_chronometre(*unite,0); // le 0 c'est le dp il es tjf off
        
       // wait(1);
        (*unite)++;
        t.reset();
    }
}
void resetchrono(SSegSRDriver_chronometre display, int* u_second, int* d_second, int* u_minute, int* d_minute)
{
        *u_second = 0;    
        *d_second = 0;    
        *u_minute = 0;      
        *d_minute = 0; 
       /* stockd_minute = 0;
        stocku_minute = 0;
        stockd_second = 0;
        stocku_second = 0;*/
        
    
        display.write_chronometre_4(*d_minute,0); 
        display.write_chronometre_3(*u_minute,0);
        display.write_chronometre_2(*d_second,0);
        display.write_chronometre(*u_second,0); // le 0 c'est le dp il es tjf off  
        

  
}

void pausechrono(SSegSRDriver_chronometre display, int* u_second, int* d_second, int* u_minute, int* d_minute)
{
       /* stockd_minute = *d_minute;
        stocku_minute = *u_minute;
        stockd_second = *d_second;
        stocku_second = *u_second;*/
        
    /*    display.write_chronometre_4(stockd_minute,0); 
        display.write_chronometre_3(stocku_minute,0);
        display.write_chronometre_2(stockd_second,0);
        display.write_chronometre(stocku_second,0); // le 0 c'est le dp il es tjf off 
        
*/
}

/*************************RESET DOMICILE***************************************/ 
void DOM_reset(SSegSRDriver_domicile display2, int u ,int d,int c)
{
        display2.write_domicile(c,0);//C
        display2.write_domicile_2(d,0);//D
        display2.write_domicile_3(u,0);//U  

}
/*************************RESET VISITEUR***************************************/ 
void VIS_reset(SSegSRDriver_visiteur display3)
{

}
/*************************RESET CHRONOMETRE************************************/ 
void CHRONO_reset(SSegSRDriver_chronometre display)
{

}









int main() 
{
   C12832_LCD lcd; //Graphics LCD
    EthernetInterface interface;
    interface.init(ip,masque,gateway);
    interface.connect();
    
    
    
    UDPSocket server;
    server.bind(MCAST_PORT);
    server.init();
      //Endpoint client;
    
           //Heure 
           
           
           Timer heure;
                       Endpoint nist;
                nist.set_address("utcnist.colorado.edu", 37);
            
                char out_buffer[] = ""; // Does not matter
                server.sendTo(nist, out_buffer, sizeof(out_buffer));
               
                
                char data[255];
               
                int n = server.receiveFrom(nist, data, sizeof(data));
            
                
                
                unsigned int timeRes = ntohl( *((unsigned int*)data));
            
              
            heure.start();
                
            int heure01;
            int heure02;
            
            int minute01;
            int minute02;
         
    //char data[256];

        //CHRONO
        int u_second = 0;     //unité seconde 
        int d_second = 0;     //dizaine seconde 
        int u_minute = 0;     //unité minute 
        int d_minute = 0;     //dizaine minute
          
        //SCORE DOMICILE
        int uniteDOM = 0;
        int dizaineDOM = 0;
        int centaineDOM = 0;
        
        //SCORE VISITEUR
        int uniteVIS =0;
        int dizaineVIS =0;
        int centaineVIS = 0;
        
        //VERIFICATIONS DES CHANGEMENT  1 = CHANGEMENT EFFECTUER 0 = AUCUN CHANGEMENT EFFECTUER
        bool incrementeDOM;
        bool decrementeDOM;
        bool incrementeVIS;
        bool decrementeVIS;
        
        //STOCKAGE
        int stockUNITEDOM;
        int stockDIZAINEDOM;
        int stockCENTAINEDOM;
                  
        int stockUNITEVIS;
        int stockDIZAINEVIS;
        int stockCENTAINEVIS;
        
        int chrono;
        
        /*int stocku_second;
        int stockd_second;
        int stocku_minute;
        int stockd_minute;*/

 
                if(heure.read_ms() >= 1000)
        {
                        set_time(timeRes);
                        time_t unixTime= time(NULL);
                        TimeStamp timeStamp(unixTime);
                       heure01= ((timeStamp.getHour()+2) /10);
                       heure02= ((timeStamp.getHour()+2) %10);
                       
                       minute01= ((timeStamp.getMinute()) /10);
                       minute02= ((timeStamp.getMinute()) %10);
                       
            display.write_chronometre_4(heure01,0); 
            display.write_chronometre_3(heure02,0);
            display.write_chronometre_2(minute01,0);
            display.write_chronometre(minute02,0); // le 0 c'est le dp il es tjf off  
            
            lcd.cls();

                 lcd.printf("%d",timeStamp.getHour()+2);
                 lcd.printf("\n");
                 lcd.printf("%d",timeStamp.getMinute());
                 lcd.printf("\n");
                 lcd.printf("%d", timeStamp.getSecond());
                 
                 timeRes+=1;      

            
                 heure.reset();
                }
        //char buffer[32]; // test buffer hour       
  
  //lcd.printf("%d", timeRes);
while(1)
{
    //INITIALISATION DES CHANGEMENT A 0 
    incrementeDOM = false;
    decrementeDOM = false;
    incrementeVIS = false;
    decrementeVIS = false;
        data[1] =0; //changer la data. serveur non blokant 
    
    server.receiveFrom(nist, data, sizeof(data));   

/***********************************BUZZER*************************************/
if(data[0]=='B' && data[1]=='U' && data[2] =='Z'  && data[3] == 'Z')
{
    Buzzer = 1;
    wait(1);
    Buzzer = 0;
}

/********************************RESET DOMICILE********************************/
if (data[0]=='R' && data[1]=='D' && data[2] =='O'  && data[3] == 'M')
{
    uniteDOM = 0;
    dizaineDOM = 0;
    centaineDOM = 0;
    //DOM_reset(display2,0,0,0);
    afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);   

}
/********************************RESET VISITEUR********************************/
if (data[0]=='R' && data[1]=='V' && data[2] =='I'  && data[3] == 'S')
{
    uniteVIS = 0;
    dizaineVIS = 0;
    centaineVIS = 0; 
    afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);
}

/***********************************LE RETOUR**********************************/




if (data[0]=='B' && data[1]=='A' && data[2] =='C'  && data[3] == 'K')
{    
/*uniteDOM = 11;
dizaineDOM = 11;
centaineDOM = 11;
afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);

uniteVIS = 11;
dizaineVIS = 11;
centaineVIS = 11;
afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);

u_second = 11;   
d_second = 11;  
u_minute = 11;  
d_minute = 11; 
affiche_chrono(display, u_second, d_second, u_minute, d_minute); */


        
/*AFFICHER HEURE */
     /*   time_t seconds = time(NULL);
        strftime(buffer, 32, "%I:%M %p", localtime(&seconds));*/


        
                 //displayHeure(heure, timeRes, heure01, heure02, minute01, minute02);

}
/***********CONFIGURATION CHRONO & SCORE LORS DU CHOIX DU SPORT****************/ 
if (//data[0]=='C' && data[1]=='T' && data[2] =='*'  && data[3] == '*' || //tenis
    //data[0]=='C' && data[1]=='R' && data[2] =='U'  && data[3] == 'G' || //rugby
    data[0]=='C' && data[1]=='B' && data[2] =='B'  && data[3] == '*' || //basket
    data[0]=='C' && data[1]=='H' && data[2] =='*'  && data[3] == '*' || //handball
    data[0]=='C' && data[1]=='F' && data[2] =='U'  && data[3] == 'T' || //futsal
    //data[0]=='C' && data[1]=='V' && data[2] =='B'  && data[3] == '*' || //volley-ball
    //data[0]=='C' && data[1]=='B' && data[2] =='A'  && data[3] == 'D' || //badminton
    //data[0]=='C' && data[1]=='T' && data[2] =='D'  && data[3] == 'T' || //tenis de table 
    data[0]=='C' && data[1]=='B' && data[2] =='O'  && data[3] == 'X' || //box
    data[0]=='C' && data[1]=='F' && data[2] =='L'  && data[3] == 'A'  //flag
   )
{
uniteDOM = 0;
dizaineDOM = 0;
centaineDOM = 0;
afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);

uniteVIS = 0;
dizaineVIS = 0;
centaineVIS = 0;
afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);

u_second = 0;   
d_second = 0;  
u_minute = 0;  
d_minute = 0; 
affiche_chrono(display, u_second, d_second, u_minute, d_minute);  
}
/***********************CONFIGURATION CHRONOMETRE******************************/    
if (data[0]=='C' && data[1]=='H' && data[2] =='R'  && data[3] == 'O') // configuration chronometre 
{
    u_second = 0;   
    d_second = 0;  
    u_minute = 0;  
    d_minute = 0; 
    affiche_chrono(display, u_second, d_second, u_minute, d_minute);
     
    uniteVIS = 11;
    dizaineVIS = 11;
    centaineVIS = 11;
    afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);
    
    uniteDOM = 11;
    dizaineDOM = 11;
    centaineDOM = 11;
    afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);

}
/******************CONFIGURATION SCORE LORS DU CHOIX DU SPORT******************/    
if (data[0]=='C' && data[1]=='V' && data[2] =='B'  && data[3] == '*' || //volley-ball
    data[0]=='C' && data[1]=='B' && data[2] =='A'  && data[3] == 'D' ||  //badminton
    data[0]=='C' && data[1]=='T' && data[2] =='D'  && data[3] == 'T'  //tenis de table 
   ) 
{
uniteDOM = 0;
dizaineDOM = 0;
centaineDOM = 0;
afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);

uniteVIS = 0;
dizaineVIS = 0;
centaineVIS = 0;
afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS); 
}

/***********************************SET DOMICILE*******************************/
if (data[0]=='S' && data[1]=='E' && data[2] =='T'  && data[3] == 'D')
{
    stockUNITEDOM= uniteDOM;  
    stockDIZAINEDOM= dizaineDOM;
    stockCENTAINEDOM= centaineDOM;

    stockUNITEVIS= uniteVIS;
    stockDIZAINEVIS= dizaineVIS;
    stockCENTAINEVIS= centaineVIS;
    
uniteDOM = 0;
dizaineDOM = 0;
centaineDOM = 0;
afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);

uniteVIS = 0;
dizaineVIS = 0;
centaineVIS = 0;
afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);
// INCREMENTER MATRICE DE LED
}
/***********************************SET VISITEUR*******************************/
if (data[0]=='S' && data[1]=='E' && data[2] =='T'  && data[3] == 'V')
{
    stockUNITEDOM= uniteDOM;  
    stockDIZAINEDOM= dizaineDOM;
    stockCENTAINEDOM= centaineDOM;

    stockUNITEVIS= uniteVIS;
    stockDIZAINEVIS= dizaineVIS;
    stockCENTAINEVIS= centaineVIS;
    
uniteDOM = 0;
dizaineDOM = 0;
centaineDOM = 0;
afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);

uniteVIS = 0;
dizaineVIS = 0;
centaineVIS = 0;
afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);
// INCREMENTER MATRICE DE LED
}    
/***********************************SET  ******************************
if (data[0]=='S' && data[1]=='E' && data[2] =='T'  && data[3] == 'V')
{
    
}*/
     
     /***********************************FIN DU MATCH*******************************/
if (data[0]=='F' && data[1]=='G' && data[2] =='A'  && data[3] == 'M')
{
   /* stockUNITEDOM= uniteDOM;  
    stockDIZAINEDOM= dizaineDOM;
    stockCENTAINEDOM= centaineDOM;

    stockUNITEVIS= uniteVIS;
    stockDIZAINEVIS= dizaineVIS;
    stockCENTAINEVIS= centaineVIS;*/
    
    Buzzer = 1;
    wait(1);
    Buzzer = 0;
    afficherDOM(display2, stockCENTAINEDOM, stockDIZAINEDOM, stockUNITEDOM);
    afficherVIS(display3, stockCENTAINEVIS, stockDIZAINEVIS, stockUNITEVIS);
    //FIN DU MATCH MATRICE A LED 
}
      
/************************SCORE DOMICILE****************************************/
/*************************INCREMENTATION DOMICILE******************************/
if (data[0]=='S' && data[1]=='D' && data[2] =='+'  && data[3] == '*')
{
    uniteDOM++;
    incrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='+'  && data[3] == '2')
{
    uniteDOM+=2; 
    incrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='+'  && data[3] == '3')
{
    uniteDOM+=3; 
    incrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='+'  && data[3] == '5')
{
    uniteDOM+=5; 
    incrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='+'  && data[3] == '6')
{
    uniteDOM+=6; 
    incrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='1'  && data[3] == '0')
{
    dizaineDOM+=1; 
    incrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='1'  && data[3] == '5')
{
    dizaineDOM+=1; 
    uniteDOM+=5; 
    incrementeDOM = true;
}

if(incrementeDOM)//SI UNE MODIFICATIONS EST FAITE FALSE DEVIENT TRUE ET RENTRE DANS LA FONCTION
{
    calculIncremente(&centaineDOM, &dizaineDOM, &uniteDOM);
    afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);
}

/************************SCORE DOMICILE****************************************/
/*************************DECREMENTATION DOMICILE******************************/

if (data[0]=='S' && data[1]=='D' && data[2] =='-'  && data[3] == '*')
{ 
    uniteDOM -= 1;
    decrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='-'  && data[3] == '2')
{
    uniteDOM -= 2;
    decrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='-'  && data[3] == '3')
{
    uniteDOM -= 3;
    decrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='-'  && data[3] == '5')
{
    uniteDOM -= 5;
    decrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='-'  && data[3] == '6')
{
    uniteDOM -= 6;
    decrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='1'  && data[3] == '0')
{
    dizaineDOM -= 1;
    decrementeDOM = true;
}

if (data[0]=='S' && data[1]=='D' && data[2] =='1'  && data[3] == '5')
{
    dizaineDOM -= 1;
    uniteDOM -=5;
    decrementeDOM = true;
}     
if(decrementeDOM)//SI UNE MODIFICATIONS EST FAITE FALSE DEVIENT TRUE ET RENTRE DANS LA FONCTION
{
    calculDecremente(&centaineDOM, &dizaineDOM, &uniteDOM);
    afficherDOM(display2, centaineDOM, dizaineDOM, uniteDOM);
}

/************************SCORE VIVITEUR****************************************/
/*************************INCREMENTATION VISITEUR******************************/
if (data[0]=='S' && data[1]=='V' && data[2] =='+'  && data[3] == '*')
{
    uniteVIS++;
    incrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='+'  && data[3] == '2')
{
    uniteVIS+=2;
    incrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='+'  && data[3] == '3')
{
    uniteVIS+=3;
    incrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='+'  && data[3] == '5')
{
    uniteVIS+=5;
    incrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='+'  && data[3] == '6')
{
    uniteVIS+=6;
    incrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='1'  && data[3] == '0')
{
    dizaineVIS+=1;
    incrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='1'  && data[3] == '5')
{
    dizaineVIS+=1;
    uniteVIS+=5;
    incrementeVIS = true;
}

if(incrementeVIS)
{
    calculIncremente(&centaineVIS, &dizaineVIS, &uniteVIS);
    afficherVIS(display3, centaineVIS, dizaineVIS, uniteVIS);
}
/*************************DECREMENTATION VISITEUR******************************/
if (data[0]=='S' && data[1]=='V' && data[2] =='-'  && data[3] == '*')
{ 
    uniteVIS -= 1;
    decrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='-'  && data[3] == '2')
{
    uniteVIS -= 2;
    decrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='-'  && data[3] == '3')
{
    uniteVIS -= 3;
    decrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='-'  && data[3] == '5')
{
    uniteVIS -= 5;
    decrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='-'  && data[3] == '6')
{
    uniteVIS -= 6;
    decrementeVIS = true;
}

if (data[0]=='S' && data[1]=='V' && data[2] =='1'  && data[3] == '0')
{
    dizaineVIS -= 1;
    decrementeVIS = true; 
}

if (data[0]=='S' && data[1]=='V' && data[2] =='1'  && data[3] == '5')
{
    dizaineVIS -= 1;
    uniteVIS -= 5;
    decrementeVIS = true; 
}

if(decrementeVIS)
{
    calculDecremente(&centaineVIS, &dizaineVIS, &uniteVIS);
    afficherVIS(display3,centaineVIS, dizaineVIS, uniteVIS);
}
/****************************PLAY CHRONOMETRE**********************************/
/*if (data[0]=='P' && data[1]=='L' && data[2] =='C'  && data[3] == 'H')
{
    //play_chrono(display,&u_second,&d_second,&u_minute,&d_minute);
    //affiche_chrono(display,u_second,d_second,u_minute,d_minute);
}*/

/****************************PLAY CHRONOMETRE**********************************/
if (data[0]=='P' && data[1]=='L' && data[2] =='C'  && data[3] == 'H') //play
{  


            /*Buzzer = 1;
            wait(1);
            Buzzer = 0;*/
                        //server.receiveFrom(client, data, sizeof(data)); 
        chrono=1;
     
        

        /*stockd_minute = d_minute;
        stocku_minute = u_minute;
        stockd_second = d_second;
        stocku_second = u_second;*/
        
      /*  if (u_second >= 10) //si unité seconde suppérieur ou égale a 9 
        {
            d_second++;     //dizaine seconde sera égale a dizaine seconde +1 
            u_second =0;    //unité seconde sera égale a  0
        }
        if (d_second >= 6)  //si dizaine seconde suppérieur ou égale a 6 (60secondes) 
        {
                d_second =0;    //dizaine seconde sera égale a 0
                u_second =0;    //unité seconde sera égale a 0
                u_minute ++;    //unité minute sera égale a unité minute +1
        }
        if (u_minute >= 10)
        {
                u_minute=0;
                d_minute++;  
        }       
        display.write_chronometre_4(d_minute,0); 
        display.write_chronometre_3(u_minute,0);
        display.write_chronometre_2(d_second,0);
        display.write_chronometre(u_second,0); // le 0 c'est le dp il es tjf off
        wait(1);
        u_second++;
        server.receiveFrom(client, data, sizeof(data)); */
    
}
/****************************RESET CHRONOMETRE*********************************/
if (data[0]=='R' && data[1]=='C' && data[2] =='H'  && data[3] == '*') //reset
{

        chrono=3; 
        /*u_second = 0;    
        d_second = 0;    
        u_minute = 0;      
        d_minute = 0; 
        stockd_minute = 0;
        stocku_minute = 0;
        stockd_second = 0;
        stocku_second = 0;
        
    
        display.write_chronometre_4(d_minute,0); 
        display.write_chronometre_3(u_minute,0);
        display.write_chronometre_2(d_second,0);
        display.write_chronometre(u_second,0); // le 0 c'est le dp il es tjf off       
*/

}
/****************************PAUSE CHRONOMETRE**********************************/
if (data[0]=='P' && data[1]=='C' && data[2] =='H'  && data[3] == '*') //pause
{
        
        chrono=2;
        
        
        /*stockd_minute = d_minute;
        stocku_minute = u_minute;
        stockd_second = d_second;
        stocku_second = u_second;
        
        display.write_chronometre_4(stockd_minute,0); 
        display.write_chronometre_3(stocku_minute,0);
        display.write_chronometre_2(stockd_second,0);
        display.write_chronometre(stocku_second,0); // le 0 c'est le dp il es tjf off    */  
}

if (data[0]=='F' && data[1]=='P' && data[2] =='E'  && data[3] == 'R') //FPERIODE
{
    chrono=2;
            Buzzer = 1;
            wait(1);
            Buzzer = 0;
}

switch(chrono)
{
    case 1: 
                playchrono(display,&u_second,&d_second,&u_minute,&d_minute);
              /*  data[1] =0; //changer la data. serveur non blokant */
                break;
    case 2: 
                pausechrono(display,&u_second,&d_second,&u_minute,&d_minute);
                break;
    case 3:     
                resetchrono(display,&u_second,&d_second,&u_minute,&d_minute);
                break;
    default:
                pausechrono(display,&u_second,&d_second,&u_minute,&d_minute);
}

}  // ferme le whimle  
}      // ferme le int 
   
