#include "mbed.h"
#include "hcsr04.h"
#include "ESP8266.h"

#define APIKEY QSL7YVXB73QHN2EK   //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
const char *WIFI_SSID     = "Nokia 7.1"; // Enter your Wi-Fi name 
const char *WIFI_PASS = "avinash1#" ; // Enter your Wi-Fi password
//#define WIFI_SSID "Nokia 7.1"
//#define WIFI_PASS "avinash1#"
HCSR04  usensor(PTC12,PTC4);
DigitalOut trigger(PTC12);
DigitalOut RED(LED1); //monitor trigger
DigitalOut GREEN(LED2); //monitor echo
InterruptIn echo(PTC4);


Serial pc (USBTX, USBRX); //Serial Communication
ESP8266 wifi (PTC17, PTC16, 115200); //Setting baud rate for Wifi Esp Module
char snd[255], rcv[1000];
#define IP "184.106.153.149"//IP address of thingspeak.com
unsigned int pulsedur;

Timer pulsetime;

void wifi_send(void);
int main()
{
unsigned int distance;
pc.baud(115200);
//Initializing Wi-Fi
pc.printf("SET mode to AP\r\n");
wifi.SetMode(1); //set the mode of ESP to 1
wifi.RcvReply(rcv,1000); //receive response by ESP
pc.printf("%s",rcv); //print the response
pc.printf("Connect to the Wifi\r\n"); //wifi name & password
wifi.Join("WIFI_SSID","WIFI_PASS");
wifi.RcvReply(rcv, 1000); //receive response by ESP
pc.printf("%s\n",rcv); //print the response
wait(8); //waiting for the response from ESP
pc.printf("Getting IP\r\n"); //getting the IP address from the connected AP
wifi.GetIP(rcv); //IP address received from AP
pc.printf("%s\n",rcv); //print response on TeraTerm
pc.printf("Initializing the Wi-Fi\r\n");


//Loop to read distance, scale and print 
while(1)
{
trigger=1;
RED=1;
GREEN=0;
pulsetime.reset();
wait_us(10);
trigger=0;
RED=0;
while(echo==0){};
GREEN=echo;
pulsetime.start();
while(echo==1){};
pulsetime.stop();
pulsedur = pulsetime.read_us();
distance= (pulsedur*343)/20000;
GREEN=0;
pc.printf("Distance is %d cm\n\r" ,distance);
pc.printf("Uploading status to the cloud\n\r");
//wait before sending another ping since echo(s) may return
wait(10);
wifi_send();
   };
}
//End of main program
//Routing data to cloud
void wifi_send(void)
{
 unsigned int distance;
pc.printf("Uploading Wi-Fi Data");
pc.printf("\r\nSet Wi-Fi into Single Channel Mode\r\n");
strcpy(snd,"AT+CIPMUX=0"); //set wi-fi into single channel mode
wifi.SendCMD(snd);
pc.printf(snd);
wifi.RcvReply(rcv,1000);
pc.printf("\r\nMode status is %s",rcv);
//Connecting to Thingspeak server
pc.printf("\r\nConnecting to Thingspeak server\r\n");
strcpy(snd,"AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80");
pc.printf("\r\nSending data: %s",snd);
wifi.SendCMD(snd);
wifi.RcvReply(rcv,1000);
pc.printf("\r\nServer status: %s",rcv);
//Deliver Data
pc.printf("\r\nDelivering Characters");
strcpy(snd,"AT+CIPSEND=4,47\n");
wifi.SendCMD(snd);
wifi.RcvReply(rcv,1000);
pc.printf("\r\nStatus sent: %s",rcv);
//Upload values to cloud website
pc.printf("Uploading data to Thingspeak\r\n");
sprintf(snd,"GET https://api.thingspeak.com/update?key=QSL7YVXB73QHN2EK\n",distance);
pc.printf("%s",snd);
wifi.SendCMD(snd);
wait(2);
wifi.RcvReply(rcv,1000);
pc.printf("\r\nStatus sent: %s",rcv);
wait(2);
//Closing connection
pc.printf("\r\nClose the connection");
strcpy(snd,"AT+CIPCLOSE");//Closing connection to the server
wifi.SendCMD(snd);
wifi.RcvReply(rcv,1000);
pc.printf("%s",rcv);
}

