#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut my_led(LED1);
PwmOut my_pwm(D2);
AnalogIn ldr(A0);

void pressed() {
    pc.baud(4800);
    while (1) {
        float c=ldr.read();
        pc.printf("LDR READING = %4.2f \r\n", c);
        if (c<0.3) {
           my_pwm.write(0.15); // Si la luminosidad menor que 0.3, el servo se establece en 0.15
        }
        else {
           my_pwm.write(0.05); // Si la luminosidad es 0.3 o mayor, el servo se establece en 0.05
        }
    }
}

int main()
{
    // Set PWM
    my_pwm.period_ms(10);
    my_pwm.write(0.1);    
    pressed();
}