#include "mbed.h"

Serial pc(USBTX, USBRX);

// Se definen la entradas analógicas

AnalogIn dataX(A1);                                
AnalogIn dataY(A2);
AnalogIn dataZ(A3);

void bucle() {
    pc.baud(4800);
    double x,y,z;
    double x_g_value,y_g_value,z_g_value;
    double roll, pitch;
    while(1) {
        x = dataX.read();
        y = dataY.read();
        z = dataZ.read();
        
        // Calculamos las aceleraciones en g
        x_g_value = ( ( ( (double)(x * 5)/1024) - 1.65 ) / 0.330 );
        y_g_value = ( ( ( (double)(y * 5)/1024) - 1.65 ) / 0.330 );
        z_g_value = ( ( ( (double)(z * 5)/1024) - 1.80 ) / 0.330 );
        
        //A partir de los valores del acelerometro, se calculan los angulos Y, X
        //respectivamente, con la formula de la tangente.
        roll = ( ( (atan2(y_g_value,z_g_value) * 180) / 3.14 ) + 180 );
        pitch = ( ( (atan2(z_g_value,x_g_value) * 180) / 3.14 ) + 180 );
        
        pc.printf("Accelerometer X : %f\n\r", x);
        pc.printf("Accelerometer Y : %f\n\r", y);
        pc.printf("Accelerometer Z : %f\n\r", z);
        pc.printf("Roll: %f\n\r",roll);
        pc.printf("pitch: %f\n\r",pitch);
        pc.printf("\n\n");
        pc.printf("\r\n");
        wait(1);
    }
}

int main() {
    bucle();
}