#include "mbed.h"

Serial pc(USBTX, USBRX);
AnalogIn ldr(A0);
PwmOut led(D2);
PwmOut led2(D7);
PwmOut led3(D8);

void intensidadLDR() {
    pc.baud(4800);
    while(1) {
        float ldrStatus = ldr.read();
        pc.printf("LDR READING = %4.2f \r\n", ldrStatus);
        if(ldrStatus >= 0.75f && ldrStatus <=1.0f) {
            led.write(0.25);
            led2.write(0.25);
            led3.write(0.25);
        } else if(ldrStatus >= 0.5f && ldrStatus < 0.75f) {
            led.write(0.5);
            led2.write(0.5);
            led3.write(0.5);
        } else if(ldrStatus >= 0.25f && ldrStatus < 0.5f) {
            led.write(0.75);
            led2.write(0.75);
            led3.write(0.75);
        } else if(ldrStatus >= 0.0f && ldrStatus < 0.25f) {
            led.write(1.0);
            led2.write(1.0);
            led3.write(1.0);
        } else {
            led.write(0.0);
            led2.write(0.0);
            led3.write(0.0);
        }
    }
}

int main() {
    intensidadLDR();
}