#ifndef MYOWNHANDLER_H
#define MYOWNHANDLER_H

#include "../HTTPRequestHandler.h"
float x,y;

class MyOwnHandler : public HTTPRequestHandler
{
  public: 
  MyOwnHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket)
                            : HTTPRequestHandler(rootPath, path, pTCPSocket) {}
  virtual ~MyOwnHandler() {}

//protected:
  static inline HTTPRequestHandler* inst(const char* rootPath,
                                         const char* path, TCPSocket* pTCPSocket)
                         { return new MyOwnHandler(rootPath, path, pTCPSocket); }

  virtual void doGet();
  virtual void doPost() {}
  virtual void doHead() {}
  
  virtual void onReadable() {}
  virtual void onWriteable() { close(); } // Data has been written,
                                          //   we can close the connection
  virtual void onClose() {}
};

void MyOwnHandler::doGet()
{
// To get request data, we use the method path()
// We assume that path() will be:
//       /variable
// or    /variable value
// Get variable string
      int endVar = path().find_first_of('%', 1);
      string variable = path().substr(1, endVar-1);
// Get value string
      string value;
      if (endVar!=string::npos) value = path().substr(endVar+3, string::npos);
// Get a pointer on the variable
// The type of the variable must be float
      float *ptr = NULL;
      if (variable.compare("x")==0) ptr=&x;
      else if (variable.compare("y")==0) ptr=&y;
//    else if (variable.compare("variable")==0) ptr=&variable;
// Get the float value and set the variable value
      if ((ptr!=NULL)&&(!value.empty())) {
          float v;
          if (sscanf(value.c_str(), "%f", &v)!=EOF) *ptr=v;
      }
// Server response will be the value of the variable
      char resp[20];
      if (ptr!=NULL) {
          sprintf(resp, "%f", *ptr);
      } else {
          sprintf(resp, "Unknown variable");
      }
      setContentLen( strlen(resp) );
      respHeaders()["Connection"] = "close";
      writeData(resp, strlen(resp));
}
 #endif