/*
Este programa ha sido desarrollado por los estudiantes:
SEBASTIAN CAMILO CASTAÑO VANEGAS Y CARLOS MAURICIO ALZATE TORRES
Para la materia de Procesadores - Universidad Nacional de Colombia - Sede Medellín
A cargo del Ingeniero Gustavo Adolfo Ramirez.
El programa es la unión de varios programas proporcionados por el usuario tony63.
Se usa un celular Siemens A56i para la comunicación por GSM,la aplicación consiste en
esperar un mensaje de texto con la frase "Donde estas?","donde estas" o "donde estas?"
que es enviada al Siemens desde cualquier otro celular, para así devolverle al remitente 
un link de Google Maps con las coordenadas de donde se encuentra en ese momento
suministradas por un GPS, que en este caso será un computador que las envía a través de 
un Dongle conectado,usando el programa de SatGen con un .kml cargado de Google Earth o 
usando el simulador GPS de Proteus (funciona para ambos casos).

NOTA: Si el led al iniciar se mantiene en rojo significa que no se ha realizado
una correcta configuración del Modem, por tanto, cambie la conexión hasta que
el led se torne Verde. El led se tornará morado cuando el mensaje de texto recibido
cumpla las condiciones de la frase.
*/

// SE DEFINEN LAS LIBRERÍAS QUE SE USARÁN
#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
#include "GPS.h"

//SALIDAS PARA VER EL ESTADO DEL PROGRAMA
Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);

// PUERTOS PARA LA COMUNICACIÓN SERIAL
Serial GSM(PTE0,PTE1);  // MODEM
Serial pc(USBTX,USBRX); // VISUALIZACIÓN DEL ESTADO DEL PROGRAMA EN EL PC
GPS gps(PTE22, PTE23);   // RECEPCIÓN DE DATOS GPS.

// DECLARACIÓN DE VARIABLES
// CADENAS QUE SE USARÁN DURANTE EL PROGRAMA
char DE1[255];
char DS1[255];
char DE2[255];
char DS2[255];
char buffer[512];
char resp[6];
char tam[2];
char mensaje[100];

//Variables enteras y caracteres ----------------------------------------------- REVISAR
int count;
int i, K, LENOUT1, LENIN1, LENOUT2, LENIN2, C;
int c=0;
char r[]=""; 
char msg[256];
char char1;
int ind;
float med;
char outmed[16], outmedn[16];
int ret = 1;

// DEDICADA PARA EL TELEFONO QUE ENVIA Y RECIBIRÁ
char tel[15];

// COORDENADAS GPS EN LATITUD Y LONGITUD
float lo,la;
char clo[255], cla[255]; // CADENAS PARA LATITUD Y LONGITUD
char la_lo[255];//---------------------------------------------------  REVISAR

// LINK DE GOOGLE MAPS
char http2[255];
char http[] = "http://maps.google.com/maps?q=";
char buf[100];

// DATOS DE RELLENO PROPIOS DEL SMS.
char relle1[] = "0011000A91";
char relle2[] = "0000AA";

// DEFINICIÓN DE FUNCIONES
void callback(){
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc.printf("%c\n", GSM.getc()); 
}

// Esta funcion de abajo lee todo un bufer hasta encontrar CR o LF y el resto lo rellena de
// $, count es lo que va a leer. Lo leido lo mete en buffer que es una cadena previamente definida
// incorpora medida de tiempo si se demora mas de tres segundos retorna fracaso con -1
int readBuffer(char *buffer,int count){
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()){  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}

// Esta función de abajo limpia o borra todo un "buffer" de tamaño "count",
// lo revisa elemento por elemento y le mete el caracter null que indica fin de cadena.
// No retorna nada.
void cleanBuffer(char *buffer, int count){
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

// Esta función de abajo envia un comando parametrizado como cadena
// puede ser un comando tipo AT.
void sendCmd(char *cmd){
    GSM.puts(cmd);
}

// Esta función de abajo espera la respuesta de un comando que debe ser idéntica a la cadena "resp" y un tiempo "timeout",
// si todo sale bien retorna un cero que en la programacion hay que validar,
// si algo sale mal (no se parece o se demora mucho) retorna -1 que debera validarse con alguna expresion logica.
int waitForResp(char *resp, int timeout){
    int len = strlen(resp);
    int sum=0;
    t.start();
 
    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}

// Esta función es muy completa y útil, se encarga de enviar el comando y esperar la respuesta.
// Si todo sale bien retorna un cero
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout){
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}

// Esta función chequea que el módem este vivo, envia AT, le contesta con OK y espera 2 segundos.
int powerCheck(void){ // Este comando se manda para verificar si el módem esta vivo o conectado.
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}

// Esta función de abajo chequea el estado de la sim card
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
int checkSIMStatus(void){
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer, 30);
    while(count < 3){
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))){
            break;
        }
        count++;
        wait(1);
    }
 
    if(count == 3){
        return -1;
    }
    return 0;
}

// Esta función de abajo chequea la calidad de la señal
// y si todo sale bien retorna con el valor de señal útil o un -1 si no es aceptable, en la programacion hay que validar
// con alguna expresión lógica.
int checkSignalStrength(void){
    char gprsBuffer[100];
    int index, count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3){
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3){
        return -1;
    }
    return index;
}
 
// Esta funcion inicaliza el módem. 
// Se compone de un grupo de subfunciones ya definidas previamente:
// primero chequea que este vivo,
// segundo chequea el estado de la simcard,
// tercero chequea la intencidad de señal celular,
// cuarto aplica la configuracion
// y si todo sale bien retorna un cero
int init(){
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 3)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 3)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 3)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CBST=7,0,1\r\n", "OK", 3)){ //velocidad fija a 9600
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("ATE\r\n", "OK", 3)){ //se le quita el eco al modem GSM
        return -1;
    }
    LedVerde=0;
    return 0;
}
  
// Esta funcion de abajo intenta leer un mensaje de texto en formato PDU o HEX
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
int readSMSpdu(char *message, int index){
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0';
    }
    return 0;
}

// Esta función de abajo borra mensajes SMS del modem
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresion logica.
int deleteSMS(int index){
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}

////////////////////////////////////////////// FUNCIÓN PRINCIPAL //////////////////////////////////////////////////////////
int main(){
    //SE CONFIGURAN LOS PUERTOS SERIALES PARA UNA CORRECTA COMUNICACIÓN    
    GSM.baud(9600);//BAUDIOS EN LA FRDMKL25Z EN 9600
    GSM.format(8,Serial::None,1); //CONFIGURA EL FORMATO DE LOS DATOS EN LA UART     
    LedVerde = 1; // APAGO LOS LEDS
    LedRojo = 1; 
    LedAzul = 1;
    LedRojo = 0; // PRENDO EL LED ROJO
    
    // CONFIGURACIÓN DEL MODEM GSM (TELEFONO CELULAR SIEMENS A56i).
    inicio1:        
        ret = init();
        if(ret==0){
            LedRojo = 1;
            LedVerde = 0; //ENCENDER LED VERDE PARA CONFIRMAR LA CONEXIÓN
            pc.printf("El Modem se ha configurado correctamente\n");
        }
        else{
            wait(1);
            goto inicio1;    
        }
        
    while(1){ 
        if (GSM.readable()){
            readBuffer(buffer,110);
            for(i=0; i<5; i++){
                resp[i] = buffer[i];
            }  
             
            if(strcmp("$$+CM", resp) == 0){  //COMPARA resp CON "+CMTI"
                pc.printf("\nHa llegado un mensaje!\r\n");
                cleanBuffer(buffer,10);
                GSM.printf("AT+CMGL=0\r\n"); // Envío comando para leer mensaje
                readBuffer(buffer,110);
                
                // LECTURA DEL TELEFONO QUE ENVIÓ EL MENSAJE
                for(i=0; i<10; i++){
                    tel[i] = buffer[i+40];
                }
                pc.printf("\nTelefono que envio el mensaje: %c%c%c%c%c%c%c%c%c%c\r\n", tel[1], tel[0], tel[3], tel[2], tel[5], tel[4], tel[7], tel[6], tel[9], tel[8]);  
                
                // LECTURA DEL TAMAÑO
                for(i=0;i<2;i++){
                    tam[i] = buffer[i + 68];
                }      
                
                // LECTURA DEL MENSAJE
                for(i=0;i<26;i++){
                   msg[i] = buffer[i+70]; // Lee un mensaje de 26 caracteres máximo desde la posición 70 del buffer.
                }
                
                // DECODIFICACIÓN DEL MENSAJE
                
                deleteSMS(1); // Se borran los mensajes por medio de una función
                readBuffer(buffer, 200);
                /* 
                SE COMPARA EL MENSAJE RECIBIDO resp CON:
                "E4B79B5C0695E7F4F01C"="donde estas"
                "E4B79B5C0695E7F4F0FC07"="donde estas?"
                "C4B79B5C0695E7F4F0FC07"="Donde estas?"
                */
                if((strncmp("E4B79B5C0695E7F4F01C", msg, 20) == 0) || (strncmp("E4B79B5C0695E7F4F0FC07", msg, 22) == 0)|| (strncmp("C4B79B5C0695E7F4F0FC07", msg, 22) == 0)){  
                    
                    LedVerde = 1; 
                    LedAzul = 0; // ENCENDER LED AZUL
                    LedRojo=0; // ENCENDER LED ROJO
                    wait(2);
                    
                    if(gps.sample()){ // SE RECIBEN COORDENADAS DEL GPS
                        lo = gps.longitude;
                        la = gps.latitude; 
                            
                        //LONGITUD
                        sprintf (clo, "%f", lo); 
                        pc.printf ("\nLongitud = %s\n",clo);
                        wait(0.5);
                    
                        // LATITUD
                        sprintf (cla, "%f", la); 
                        pc.printf ( "\nLatitud = %s\n",cla);
                        wait(0.5);
                        
                        // SE CONCATENAN LAS COORDENADAS DE LATITUD Y LONGITUD
                        strcpy(la_lo,cla);
                        strcat(la_lo,",");
                        strcat(la_lo,clo);
                        
                        //SE UNEN LAS CADENAS Y SE ARMA EL URL
                        strcpy(DE1,http);
                        strcat(DE1,la_lo);         
                        pc.printf("\nDireccion URL que se enviara: %s\n",DE1);
                        pc.printf("\n");
                        LENIN1 = strlen(DE1);
                        
                        //CONVERSIÓN A OCTETOS
                        K = 0;
                        C = 0;
                        for (i = 0; i < LENIN1; i++){
                            DS1[i] = DE1[i + C] >> K | DE1[i + C + 1] << (7 - K);
                            if(DS1[i] == 0x00) {LENOUT1 = i; goto salir1;}   
                            K++;
                            if (K == 7) {K = 0; C++;} // se chequea que ya se acabaron los bits en un ciclo de conversion.
                        }
                        
                        salir1:
                            for (i = 0; i < LENIN1; i++){
                                pc.printf("%X", DE1[i]);
                            }
                        
                            pc.printf(":\r\n");
                            for (i = 0; i < LENOUT1; i++){
                                pc.printf("%2X", DS1[i]&0x000000FF);
                            }                        
                            pc.printf("\r\nLENOUT GPS: %d, LENIN GPS: %2X\r\n", LENOUT1, LENIN1);
                        
                        // Concatenación del mensaje en formato PDU y envío del mismo.
                        ind = 14 + LENOUT1 - 1;
                        
                        GSM.printf("AT+CMGS=%d\r\n",ind);
                        pc.printf("AT+CMGS=%d\r\n",ind);
                        pc.printf(relle1);
                        GSM.printf(relle1);
                        
                        for (i=0 ;i<=9; i++)  {
                            pc.printf("%c",tel[i]);
                            GSM.printf("%c",tel[i]);
                        }
                        
                        pc.printf(relle2);
                        GSM.printf(relle2);
                        pc.printf("%2X", LENIN1);
                        GSM.printf("%2X", LENIN1);
                         
                        for (i = 0; i < LENOUT1; i++){
                            pc.printf("%02X", DS1[i]&0x000000FF);
                            GSM.printf("%02X", DS1[i]&0x000000FF);
                        }
                        wait(1);
                        GSM.putc((char)0x1A); // Ctrl - Z.
                        GSM.scanf("%s",buf); // Estado del mensaje (Envió o Error).
                        pc.printf("\n>%s\n",buf);
                    }
                    
                    wait(1);
                    LedAzul = 1;
                    LedRojo = 1;
                    LedVerde = 0;
                    GSM.printf("AT+CMGD=0\r\n"); // Borra el mensaje actual (Posición "0").
                    pc.printf("%s\n\n", "El mensaje ha sido borrado del celular");
                    goto inicio1; // SE RECONFIGURA EL MODEM PARA ESTAR PENDIENTE A OTRO NUEVO MENSAJE
                }
            } 
        }         
    }
}