//Acknowledgement(rfid): Donatien Garnier (http://mbed.org/users/donatien/code/RSEDP_DPDemo/file/fd63457452f4/main.cpp)

#include "mbed.h"
//self included
#include "RWDMifare.h"

//defines
#define MAX_UID_LEN 10 //Mifare max UID length is 10 bytes (triple-uid)
#define CMD_LENGTH 128

uint8_t CMD[CMD_LENGTH];

//setup hardware
DigitalOut myled(LED1);
RWDMifare reader(p9, p10, p30);
Serial pc (USBTX, USBRX);
DigitalIn CardDetect (p29);


bool CMD_Received;
uint8_t CMD_Ptr;
uint8_t *ptr;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

//! Method to read from UART and control if a command has been received
void callback() {
    if(!CMD_Received) //previous cmd executed
    {
        CMD[CMD_Ptr] = (uint8_t)pc.getc();
        pc.putc(CMD[CMD_Ptr]);     
        if (CMD[CMD_Ptr] == 13){
            CMD_Received = true;
            CMD_Ptr = 0;
        }
        else{
            CMD_Ptr++;
        }
    }
}

uint8_t CharToInt(char c)
{
    if((c >= '0') && (c <= '9'))
        return c - '0';
    if((c >= 'A') && (c <= 'F'))
        return c - 'A' + 10;
    if((c >= 'a') && (c <= 'f'))
        return c - 'a' + 10;
    return -1;
}
int main()
{
    //Reading Mifare
    uint8_t uid[MAX_UID_LEN]; //< Buffer for UID
    CMD_Received = false;
    CMD_Ptr = 0;
    size_t uidLen = 4;
    uint8_t Data[16];

    pc.attach(&callback);
    pc.printf("\xCMifare Card Reader\n\r");
    
    //Init Mifare Reader
    RWDMifare::RWDMifareErr readerErr = reader.init();
    if(readerErr) {
        pc.printf("Could not init reader (error %d)\r\n", readerErr);
        return -1;
    }

    while(1) {
         if(CMD_Received)
         {
            ptr = CMD; //set the pointer
            switch(*ptr++)
            {
                case 's': /*!<get status [no args] */
                    uint8_t *status;
                    readerErr = reader.getStatus(status);
                    reader.printStatus(*status); //print it out.
                    break;
                case 'u': //get a UID of the card [no args]
                    pc.printf("UID=0x");
                    if(!reader.getUID(uid, &uidLen)) { //Got an UID successfully
                        uidLen = (uidLen < 4) ? uidLen : 4; //Check length
                        for(int i = 0; i < uidLen; i++)
                            pc.printf("%02x", uid[i]);
                        pc.printf("\n\r");
                    }
                    else{
                        pc.printf("None");
                    }    
                    break;
                case 'r'://read a card block
                    // CMD of form = 'r' <key_num> [A|B] <block addr> <num of blocks>
                    while(*ptr == ' ') 
                        ptr++; //skip white space
                    uint8_t key = atoi((char*)ptr);
                    key &= 0x1F; //need to mask it
                    while(*ptr != ' ') 
                        ptr++; //find next white space
                    while(*ptr == ' ') 
                        ptr++; // then skip white space
                    if((*ptr == 'A') | (*ptr == 'a'))//type A
                        key &= ~0x80; //turn off MSb
                    else if((*ptr == 'B') | (*ptr == 'b'))
                        key |= 0x80; //turn on MSb
                    else {
                        pc.printf("\n\rKey type error");
                        break;
                    }
                    while(*ptr != ' ') 
                        ptr++; //find next white space
                    while(*ptr == ' ') 
                        ptr++; // then skip white space
                    
                    
                    uint8_t Block = atoi((char*)ptr);
                    int8_t length = 1;
                    while(*ptr != ' ') 
                        ptr++; //find next white space
                    while(*ptr == ' ') 
                        ptr++; // then skip white space
                    
                    if(*ptr)
                        length = atoi((char*)ptr);
                    if(length == 1)
                        pc.printf("\n\rKey = %d, type: %c: Block: %d", key & 0x1F, key&0x80? 'B':'A', Block);
                    else
                        pc.printf("\n\rKey = %d, type: %c: Blocks: %d, Number of blocks: %d", key & 0x1F, key&0x80? 'B':'A', Block, length);
                    
                    for(int j = 0; j < length; j++){
                        readerErr = reader.ReadBlock(Block+j, key, Data);
                        if(!readerErr)
                        {
                            pc.printf("\n\r");
                            for(int i = 0; i < 16; i ++)
                                pc.printf("%02x", Data[i]);
                        }
                        else
                        {
                            pc.printf("Fail");
                            length = -1;//escape
                        }
                    }
                    break;
                    
                case 'k': // k <number> [6 byte key in hex, no spaces]
                    while(*(ptr++) == ' ') ;
                    //get number id of key to write
                    uint8_t num = atoi((char*)ptr);
                    while(*ptr != ' ') 
                        ptr++; //find next white space
                    while(*ptr == ' ') 
                        ptr++; // then skip white space
                    uint8_t key_ar[6] = {0};
                    
                    for (int i = 0; i < 6; i++)
                    {
                        key_ar[i] |= CharToInt(*ptr) << 4; 
                        ptr++;
                        key_ar[i] |= CharToInt(*ptr);  
                        ptr++;
                    }
                    pc.printf("Key received: {");
                    for(int i = 0; i < 6; i++)
                    {
                        pc.printf("%02x", key_ar[i]);
                    }
                    pc.printf("}\n\r");
                    readerErr = reader.StoreKey(num, key_ar);
                    if(readerErr){
                       pc.printf("Write Key Failed\n\r");
                    }
                    else{
                        pc.printf("Write Key successfull\n\r");   
                    }
                    
                    break;
                case 'P': //program EEPROM: P <addr> <val> (hex)
                    while(*ptr == ' ')
                        ptr++;
                    uint8_t addr = CharToInt(*ptr); 
                    ptr++;
                    if(*ptr != ' ')
                    {
                        addr <<= 4;
                        addr |= CharToInt(*ptr);  
                        ptr++;
                    }
                    while(*ptr != ' ')
                        ptr++;
                    while(*ptr == ' ')
                        ptr++;
                    uint8_t val = CharToInt(*ptr); 
                    ptr++;
                    if(*ptr != ' ')
                    {
                        val <<= 4;
                        val |= CharToInt(*ptr);  
                        ptr++;
                    }
                    
                    pc.printf("\n\rAddr = 0x%02x, Data = 0x%02x", addr, val);
                    readerErr = reader.Prog_EEPROM(addr, val);
                    if(readerErr)
                        pc.printf("\n\rWrite Error");
                    else
                        pc.printf("\n\rSuccess");
                    break;
                case '?':
                    pc.printf("\n\rMifare Card Reader / Writer software.");
                    pc.printf("\n\rCommands: ");
                    pc.printf("\n\r\t'?' - Shows this prompt");
                    pc.printf("\n\r\t's' - Gets and prints Device status");
                    pc.printf("\n\r\t'u' - Gets and prints the UID of a card if in detect");
                    pc.printf("\n\r\t'P' - Programs the EEPROM - use \"P [addr] [value]\". addr and value should be in hex");
                    pc.printf("\n\r\t'k' - Stores a key to EEPROM - use \"k [key_id] [key - 6 bytes in hex]\" e.g. k 0 a0a1a2a3a4a5");
                    pc.printf("\n\r\t'r' - Reads data from the card if in detect - use \"r [key_id] [type='A'|'B'] [block addr] (num of blocks)\" e.g. 'r 0 A 0 4'");
                    pc.printf("[_] indicates a mandatory field. (_) indicates an optional field.");
                    break;
                default:
                    pc.printf("Command %c not recognised\n\r? - help prompt", *(ptr-1));
                    break;
            }
            CMD_Received=false;//dealt with command
            pc.printf("\r\n");
        }
            
    }
}

/*
               case 'w':
                    uint8_t WrData[16] = {0xc3,0x1e,0x71,0xda,0x77,0x98,0x02,0x00,0xe1,0x50,0x00,0x00,0x00,0x00,0xFF,0x11};

                    readerErr=reader.WriteBlock(Addr,Key,Type,WrData);
                    if(readerErr){
                    pc.printf("Write Block Failed\n\r");
                    }
                    else{
                        pc.printf("Write Block successfull\n\r");   
                    }
                    break;
*/