//
// OV7670 library
//

#pragma once 
#include "mbed.h"
#include "ov7670reg.h"

#define OV7670_WRITE (0x42)
#define OV7670_READ  (0x43)
#define OV7670_WRITEWAIT (20)
#define OV7670_NOACK (0)
#define OV7670_REGMAX (201)
#define OV7670_I2CFREQ (100000) 


class OV7670
{
    public:
        PortIn data;
        OV7670(
            PinName sda,    // Camera I2C port
            PinName scl,    // Camera I2C port
            PinName vs,     // VSYNC
            PinName hr,     // HREF
            PinName we,     // WEN
            PortName port,
            int mask,
            PinName rt,     // /RRST
            PinName o,      // /OE
            PinName rc      // RCLK      
            );
        
        ~OV7670();
        
        void CaptureNext(void);              // capture request
        bool CaptureDone(void);              // capture done? (with clear)
        void WriteReg(int addr,int data);    // write to camera
        int ReadReg(int addr);               // read from camera
        void Reset(void);                    // reset reg camera
        int Init(char c, int n);             // init reg    
        void VsyncHandler(void);             // vsync handler
        void HrefHandler(void);              // href handler
        int ReadOnebyte(void);               // Data Read
        void ReadStart(void);                // Data Start
        void ReadStop(void);                 // Data Stop
       
        
    private:
        I2C _i2c;
        InterruptIn vsync,href;
        //BusIn data;
        
        DigitalOut wen;
        DigitalOut rrst,oe,rclk;
        volatile int LineCounter;
        volatile int LastLines;
        volatile bool CaptureReq;
        volatile bool Busy;
        volatile bool Done; 
};
