//
// OV7670 library
//

#pragma once 
#include "mbed.h"
#include "ov7670reg.h"

#define OV7670_WRITE (0x42)
#define OV7670_READ  (0x43)
#define OV7670_WRITEWAIT (20)
#define OV7670_NOACK (0)
#define OV7670_REGMAX (201)
#define OV7670_I2CFREQ (100000) 


class OV7670
{
    public:
            
        OV7670(
            PinName sda,    // Camera I2C port
            PinName scl,    // Camera I2C port
            PinName vs,     // VSYNC
            PinName hr,     // HREF
            PinName we,     // WEN
            PinName d7, // D7
            PinName d6, // D6
            PinName d5, // D5
            PinName d4, // D4
            PinName d3, // D3
            PinName d2, // D2
            PinName d1, // D1
            PinName d0, // D0
            PinName rt,     // /RRST
            PinName o,      // /OE
            PinName rc      // RCLK      
            );
        
        ~OV7670();
        
        void CaptureNext(void);              // capture request
        bool CaptureDone(void);              // capture done? (with clear)
        void WriteReg(int addr,int data);    // write to camera
        int ReadReg(int addr);               // read from camera
        void Reset(void);                    // reset reg camera
        int Init(char c, int n);             // init reg    
        void VsyncHandler(void);             // vsync handler
        void HrefHandler(void);              // href handler
        int ReadOnebyte(void);               // Data Read
        void ReadStart(void);                // Data Start
        void ReadStop(void);                 // Data Stop
       
        
    private:
        I2C _i2c;
        InterruptIn vsync,href;
        BusIn data;
        DigitalOut wen;
        /*
        DigitalIn da7;
        DigitalIn da6;
        DigitalIn da5;
        DigitalIn da4;
        DigitalIn da3;
        DigitalIn da2;
        DigitalIn da1;
        DigitalIn da0;
        */
        DigitalOut rrst,oe,rclk;
        volatile int LineCounter;
        volatile int LastLines;
        volatile bool CaptureReq;
        volatile bool Busy;
        volatile bool Done; 
};
