//
// OV7670 + FIFO AL422B camera board test
//
#include "mbed.h"
#include "ov7670.h"

OV7670 camera(
    PTC10,PTC11,       // SDA,SCL(I2C / SCCB)
    PTA1,PTA0,   // VSYNC,HREF
    PTC3,PTC2,PTA2,PTB23,PTB11,PTB10,PTB3,PTB2, // D7-D0
    PTD2,PTB9) ; // RRST,RCLK

Serial pc(USBTX,USBRX) ;

#define SIZEX (160)
#define SIZEY (120)
#define SIZE 19200

unsigned char bank0 [SIZE];
unsigned char *bank1 = (unsigned char *)(0x2007C000);

int main() {
    // Reset camera on power up
    camera.Reset() ;

    // Set up for 160*120 pixels RGB565
    camera.InitQQVGA() ;
    
    // Print message to screen
    pc.printf("Hit Any Key to stop RGBx160x120 Capture Data.\r\n");
          
    // Kick things off by capturing an image
    camera.CaptureNext() ;
    while (camera.CaptureDone() == false) ;

    // Now enter the main loop
    //while (!pc.readable()) {

        // Start reading in the image data from the camera hardware buffer                   
        camera.ReadStart();

        // Read in the first half of the image
        for (int i = 0; i < SIZE; i++) {
            bank0[i] =  camera.ReadOneByte();
        }

        // Read in the second half of the image
        for (int i = 0; i < SIZE ; i++) {
            bank1[i] =  camera.ReadOneByte();
        }  
        
        // Stop reading the image
        camera.ReadStop() ; 
        
        // Immediately request the next image to be captured (takes around 45ms)
        //camera.CaptureNext() ;
        
        // Use this time to display the image on the screen
        // Display the top half

        /* Note: we still have around 15ms left here to do other stuff */
        
        // Now wait for the image to finish being captured
        //while (camera.CaptureDone() == false) ;
    //}
}
