#include "main.h"
#include "EthernetInterface.h"
#define VGA     307200         //640*480
#define QVGA    76800          //320*240
#define QQVGA   19200          //160*120
#define lines 120
#define columns 160
EthernetInterface net;
UDPSocket sock;

void ether(){
    net.connect();
    const char *ip = net.get_ip_address();
    pc.printf("IP address is: %s\n", ip ? ip : "No IP");
    sock.open(&net);
}

int main() 
{   char fin[]="Finished";
    char start[]="Start";
    short int pixel[columns+1];
    pc.printf("Lets go");
    ether();
    camera.Init('y', QQVGA);
    pc.printf("\r\nCamera initiated\r\n");
    //Start capturing images in black and white
    camera.CaptureNext();
    
    while(1){
        t.reset();
        t.start();
        //camera.CaptureNext();
        while(camera.CaptureDone() == false);
        camera.ReadStop();
        camera.ReadStart();  
        led1=0;
        //Picture starts
        sock.sendto("192.168.1.6", 1001, start, sizeof(start));
        for(int x = 0; x<lines; x++){
            pixel[0]=x;
            for(int j=0; j<columns; j++){
                camera.ReadOnebyte();
                pixel[j+1]=camera.ReadOnebyte();
                //pc.printf("%d", pixel[j]);
            }
            //start capturing next picture while still reading current
            if (x==1){
                camera.CaptureNext();
            }
            //Send picture line by line
            sock.sendto("192.168.1.6", 1001, pixel, sizeof(pixel));
        }
        //Picture ends
        sock.sendto("192.168.1.6", 1001, fin, sizeof(fin));
        led1=1;
        pc.printf("\r\nDone in %f\r\n",t.read());
        //wait(0.4);
    }
}