#include "mbed.h"
#include "wdt.h"
// Lab 6
// ---------------------------------
//    * Three threads co-operate to flash two LEDs
//    * A simple way to inject a fault, by pressing a button 
//    * The watchdog is configured with a 1024ms timeout
//    * To kick the watchdog, both LED threads must set a signal that is received by another thread which kicks it
//    * If hardware fails, turn on red on-board LED.

//This code was tested, since I had the KL25Z available

#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF);
DigitalOut redled(LED1,ON);
AnalogIn ain(PTB0) ; 
AnalogIn anin(PTE20) ;
Serial pc(USBTX, USBRX); // tx, rx, useful for debugging
Ticker tick;

// Threads
Thread threadT(osPriorityNormal, 2000); ; // timer thread 
Thread threadLED1(osPriorityNormal, 2000); ; // thread LED1
Thread threadLED2(osPriorityNormal, 2000); ; // thread LED2
Thread threadkick(osPriorityNormal, 2000); ; // thread LED2

# define ON1 (1UL << 0)   
# define ON2 (1UL << 1)
# define OFF1 (1UL << 2)  
# define OFF2 (1UL << 3)
# define kick1 (1UL << 4)  
# define kick2 (1UL << 5)
EventFlags signals;  // event flags for signalling


// ------------Fault Injection Button-------------
//  Wait while the button is down
//     Use this to simulate a STUCK fault
// -----------------------------------------------
void waitButton() {
    while (!button) ;  
}

void kickthread(){
    while(1){
        signals.wait_all(kick1 | kick2);
        wdt_kickA();//kick watchdog channel A   
    }   
}

// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON1 | OFF1); // wait for either signal
        if (evt & ON1) led1 = ON ;
        if (evt & OFF1) led1 = OFF ;
        signals.set(kick1);
        //waitButton() ;  // POSSIBLE FAULT HERE
    }
}

// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals 
// -----------------------------------------------
void led2_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON2 | OFF2); // wait for any signal
        if (evt & ON2) led2 = ON ;
        if (evt & OFF2) led2 = OFF ;
        signals.set(kick2);
        // waitButton() ; // POSSIBLE FAULT HERE
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    while (true) {
        ThisThread::sleep_for(1000) ;
        signals.set(ON1 | ON2) ;
        ThisThread::sleep_for(1000) ;
        signals.set(OFF1 | OFF2) ;
        // waitButton() ; // POSSIBLE FAULT HERE
    }
}

// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 1024ms  
// ----------------------------------------------

int main(void) {
    float volts = 0 ;
    float volts2=0;
    int counter = 0 ;
    wdt_1sec() ; // initialise watchdog - 1s timeout
    wdt_kick_all() ;  

    // start threads
    threadT.start(timer_thread) ; // start the timer thread 
    threadLED1.start(led1_thread) ; // start the LED1 control thread 
    threadLED2.start(led2_thread) ; // start the LED2 control thread 
    threadkick.start(kickthread); // start the thread to kick watchdog
    //printf("\nRESTART\n");// Debugging
    while (true) {
        if (led1==ON || led2==ON){//Only check when LEDs are on
            wdt_kickB();//Kick watchdog channel B
            volts=ain.read();
            volts=volts*3.3;
            volts2=anin.read()*3.3;
            //Voltage with LEDs on is around 1.2V, since the resistances available were not of 680ohms.
            if (volts>1.5 || volts2>1.5 || volts<0.5 || volts2<0.5){redled=0;}//Turn on on-board LED
        }
        //printf("volts: %f volts 2: %f", volts, volts2);//Debugging
        volts=0; volts2=0;
        wait(0.1f);
    }
        
    
}