#include "mbed.h"
#include "TSISensor.h"

//Lab 5 part 2

Serial pc(USBTX, USBRX); // tx, rx
PwmOut redLED(LED_RED);
PwmOut greenLED(LED_GREEN);
TSISensor tsi;
Timer t;

enum pos{neutral, lo, li, ri, ro};

Thread green ; // thread for green LED
Thread red ; // thread for red LED

# define lout 0x01   
# define lin 0x02
# define rin 0x04
# define rout 0x08  
EventFlags signals;  
volatile uint32_t flags_red;
volatile uint32_t flags_green;

void changebrightnessred() {  // method to run in thread
    float i=0;
    while (true) {
        signals.wait_any(lin,osWaitForever,false);//Run thread indefinitely after left is is pressed
        flags_red=signals.wait_any(lout|rout,osWaitForever,true);
        if (flags_red==3){//If left out is pressed, less brightness
            if (i!=0) i--;
        }
        if (flags_red==10){//If right out is pressed, more brightness
            if (i!=9) i++;
        }
        signals.clear(lout); 
        signals.clear(rout);
        //pc.printf("flags_red: %d, red: %f   \n ",flags_red, i);
        redLED= 1-i/10;
    }
}

void changebrightnessgreen() {  // method to run in thread
    float i=0;
    while (true) {
        signals.wait_any(rin,osWaitForever,false);//Run indefinitely after right in pressed
        flags_green=signals.wait_any(lout|rout,osWaitForever,true);
        if (flags_green==5){//Left out less brightness
            if (i!=0) i--;
        }
        if (flags_green==12){//Right out more brightness
            if (i!=9) i++;
        }
        signals.clear(lout); 
        signals.clear(rout);
        //pc.printf("flags_green: %d,  green: %f \n",flags_green,  i);
        greenLED= 1-i/10;
    }
}

int main(void) {
    redLED = true ; // turn off 
    greenLED = true ; // turn off 
    red.start(changebrightnessgreen) ; // start the red thread
    green.start(changebrightnessred) ; // start the green thread
    int pos=neutral;
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        switch (pos){
            case neutral:
                if (d>3 && d<9){pos=lo; signals.set(lout); t.start();}    
                if (d>13 && d<19){pos=li; signals.set(lin); signals.clear(rin);} //Select LED
                if (d>23 && d<29){pos=ri; signals.set(rin);signals.clear(lin);} //Select LED
                if (d>33){pos=ro; signals.set(rout); t.start();} 
            break;
            case lo:
                if (t.read()>1) {signals.set(lout); t.reset();}//Repeat event after 1 second
                if (d<3 || d>9) {pos=neutral; t.reset(); t.stop();}
            break;
            case li:
                if (d<13 || d>19) {pos=neutral; }
            break;
            case ri:
                if (d<23 || d>29) {pos=neutral; }
            break;
            case ro:
                if (t.read()>1) {signals.set(rout);t.reset();}//repeat event after 1 second
                if (d<33) {pos=neutral; t.reset(); t.stop();}
            break;
        }
        //pc.printf("%d, position: %d", d, pos) ;  
        //pc.putc(' ') ;
        ThisThread::sleep_for(50) ; 
        }
}