#include "mbed.h"
#include "TSISensor.h"

//Lab 5 part 1 
//LED light up according to which button is pressed

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(PTD3,0);
DigitalOut led2(PTD5,0);
DigitalOut led3(PTD0,0);
DigitalOut led4(PTD2,0);
TSISensor tsi;

Thread l_out ; 
Thread l_in ; 
Thread r_out ; 
Thread r_in ; 

enum pos{neutral, lo, li, ri, ro};
enum ledonoff{on, off};

# define lout 0x01   
# define lin 0x02
# define rin 0x04
# define rout 0x08   

EventFlags signals;  

void leftout() {  
    int l1=on;
    while (true) {
        switch (l1){
            case on:
                signals.wait_any(lout);//Wait until flag
                //pc.printf("lo  ");
                led1=1;
                l1=off;//Turn LED on or off
                signals.clear(lout);
            break;
            case off:
                signals.wait_any(lout);
                //pc.printf("lo  ");
                led1=0;
                l1=on;
                signals.clear(lout);
            break;    
        } 
    }
}
void leftin() {  
    int l2=on;
    while (true) {
        switch (l2){
            case on:
                signals.wait_any(lin);
                //pc.printf("li  ");
                led2=1;
                l2=off;
                signals.clear(lin);
            break;
            case off:
                signals.wait_any(lin);
                //pc.printf("li  ");
                led2=0;
                l2=on;
                signals.clear(lin);
            break;    
        } 
    }
}
void rightin() {  
    int l3=on;
    while (true) {
        switch (l3){
            case on:
                signals.wait_any(rin);
                //pc.printf("ri    ");
                led3=1;
                l3=off;
                signals.clear(rin);
            break;
            case off:
                signals.wait_any(rin);
                //pc.printf("ri   ");
                led3=0;
                l3=on;
                signals.clear(rin);
            break;    
        } 
    }
}
void rightout() {  
    int l4=on;
    while (true) {
        switch (l4){
            case on:
                signals.wait_any(rout);
                //pc.printf("ro   ");
                led4=1;
                l4=off;
                signals.clear(rout);
            break;
            case off:
                signals.wait_any(rout);
                //pc.printf("ro   ");
                led4=0;
                l4=on;
                signals.clear(rout);
            break;    
        } 
    }
}

int main(void) {
    int pos=neutral;
    uint8_t d;
    pc.printf("START");
    l_out.start(leftout) ; 
    l_in.start(leftin) ; 
    r_in.start(rightin);
    r_out.start(rightout);
    
    while (true) {
        d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        switch (pos){
            case neutral:
                if (d>3 && d<9){pos=lo; signals.set(lout);}    //Set flags and change states
                if (d>13 && d<19){pos=li; signals.set(lin);} 
                if (d>23 && d<29){pos=ri; signals.set(rin);} 
                if (d>33){pos=ro; signals.set(rout);} 
            break;
            case lo:
                if (d<3 || d>9) pos=neutral;
            break;
            case li:
                if (d<13 || d>19) pos=neutral;
            break;
            case ri:
                if (d<23 || d>29) pos=neutral;
            break;
            case ro:
                if (d<33) pos=neutral;
            break;
        }
        pc.printf("%d", d) ;  
        pc.putc(' ') ;
        ThisThread::sleep_for(100) ; 
        }
}