#include "mbed.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)
    Ticker tick;
    DigitalOut rled(LED1,1);
    DigitalOut gled(LED2,1);
    Serial pc(USBTX, USBRX); // tx, rx
    Timer t;
    
EventQueue queue;  // creates an event queue, to call read ADC
Thread eventThread;
EventFlags flag;

enum state { intermediate, flat, over, down, up, left, right};
volatile int state;
enum seq {f, r, u, trig, err};
volatile int seq=f;
volatile uint32_t flags_read=1;

    
void checksequence(){
    switch (seq){
           case f:
                flags_read=flag.wait_any(flat|down|over|up|left|right,10000,true);
                pc.printf("Position:%d\r\n", flags_read);
                if (flags_read==-2) {rled=1;}
                else{
                    if (flags_read!=1 && t.read()<10){seq=err;}
                    if (flags_read==6 && t.read()>10) {seq=r; t.reset();}
                    if ((flags_read!=6 && flags_read!=1) && t.read()>10){seq=err;}
                }
           break;
           
           case r:
                flags_read=flag.wait_any(flat|down|over|up|left|right,6000,true);
                pc.printf("Position:%d\r\n", flags_read);
                if (flags_read!=6 && t.read()<2){seq=err;}
                if (flags_read==4 && t.read()>2) {seq=u; t.reset();}
                if (flags_read!=6 && flags_read!=4){seq=err;}
           break;
           
           case u:
                flags_read=flag.wait_any(flat|down|over|up|left|right,8000,true);
                pc.printf("Position:%d\r\n", flags_read);
                if (flags_read!=4 && t.read()<4){seq=err;}
                if (flags_read==1 && t.read()>4) {seq=trig;}
                if (flags_read!=1 && flags_read!=4){seq=err;}
           break;
           
           case trig:
               gled=0;
           break; 
           
           case err:
                rled=0;
                flag.wait_any(flat, osWaitForever, true);
                seq=f;
                t.reset();
           break;
    }   
}

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
    // Start the event queue
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
    // call the readA0 function every 10ms 
    queue.call_every(10, checksequence) ; 

    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    state=flat;
    t.start();
    

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        switch (state){
            case intermediate:
                //rled=1;
                //gled=1;
                if (z>0.9) {state=flat; flag.set(flat);}
                if (z<-0.9) {state=over; flag.set(over);}
                if (x>0.9) {state=down; flag.set(down);}
                if (x<-0.9) {state=up; flag.set(up);}
                if (y>0.9) {state=left; flag.set(left);}
                if (y<-0.9) {state=right; flag.set(right);}
            break;
            
            case flat:
                //rled=0;
                if (z<0.8) state=intermediate;
            break;
            
            case over:
                //gled=0;
                
                if (z>-0.8) state=intermediate;  
            break;
              
            case down:
                //bled=0;
                
                if (x<0.8) state=intermediate;  
            break;
            
            case up:
                //rled=0;
                //gled=0;
                
                if (x>-0.8) state=intermediate;  
            break;
            
            case left:
                //gled=0;
                //bled=0;
                
                if (y<0.8) state=intermediate;  
            break;
            
            case right:
                //rled=0;
                //bled=0;
                if (y>-0.8) state=intermediate;  
            break;
        }
        ThisThread::sleep_for(300);  // wait(0.3);
        pc.printf("state:%d, sequence:%d, timing:%f \n", state, seq, t.read());
        
    }
}