#include "mbed.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)
enum state { intermediate, flat, over, down, up, left, right};
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    DigitalOut rled(LED1,1);
    DigitalOut gled(LED2,1);
    DigitalOut bled(LED3,1);
    Serial pc(USBTX, USBRX); // tx, rx
    int state;

    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    state=intermediate;
    while (true) {
        float x, y, z;
        
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        switch (state){
            case intermediate:
                rled=1;
                gled=1;
                bled=1;
                if (z>0.9) {state=flat; pc.printf("Flat");}//Check position and change state
                if (z<-0.9) {state=over; pc.printf("Over");}
                if (x>0.9) {state=down; pc.printf("Down");}
                if (x<-0.9) {state=up; pc.printf("Up");}
                if (y>0.9) {state=left; pc.printf("Left");}
                if (y<-0.9) {state=right; pc.printf("Right");}
            break;
            
            case flat:
                rled=0;
                if (z<0.8) state=intermediate;
            break;
            
            case over:
                gled=0;
                if (z>-0.8) state=intermediate;  
            break;
              
            case down:
                bled=0;
                if (x<0.8) state=intermediate;  
            break;
            
            case up:
                rled=0;
                gled=0;
                if (x>-0.8) state=intermediate;  
            break;
            
            case left:
                gled=0;
                bled=0;
                if (y<0.8) state=intermediate;  
            break;
            
            case right:
                rled=0;
                bled=0;
                if (y>-0.8) state=intermediate;  
            break;
        }
        ThisThread::sleep_for(300);  // wait(0.3);
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
        
    }
}
