#include "PMS5003.h"

//#include "DmTftHX8353C.h"
//#include "DmTftS6D0164.h"
//#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"
#include "DmTouch.h"
#include "DmTpFt6x06.h"

//#define log(...) printf(__VA_ARGS__)
#define log(...)

/* Displays without adapter */
#define DM_PIN_SPI_MOSI   D11
#define DM_PIN_SPI_MISO   D12
#define DM_PIN_SPI_SCK   D13
#define DM_PIN_CS_TOUCH   D4
#define DM_PIN_CS_TFT     D10
#define DM_PIN_CS_SDCARD  D8
#define DM_PIN_CS_FLASH   D6
/******************************************************************************
 * Local variables
 *****************************************************************************/
 
/*********  TFT DISPLAY INIT *********/
DmTftIli9341 tft(D10, D9, D11, D12, D13);  /* DmTftIli9341(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk)  DM_TFT28_105 and DM_TFT28_116*/
DmTouch touch(DmTouch::DM_TFT28_105, D11, D12, D13);

DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
  DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif
/*********  SENSOR INIT *********/
PMS5003 pm25(D1, D0, D3); // UART TX, UART RX, POWER

/******************************************************************************
 * Global variables
 *****************************************************************************/
uint16_t pm = 0;

/******************************************************************************
 * Local functions
 *****************************************************************************/
static EventQueue queue; // The callback from the driver is triggered from IRQ, use EventQueue to debounce to normal context

void pm25_data_callback(pms5003_data_t data) {
    printf("---------------------------------------\n");
    printf("Concentration Units (standard)\n");
    printf("PM 1.0: %u", data.pm10_standard);
    printf("\t\tPM 2.5: %u", data.pm25_standard);
    tft.drawString(70, 100, "PM 2.5:");
    tft.drawNumber(150, 100, data.pm25_standard, 2, false);
    printf("\t\tPM 10: %u\n", data.pm100_standard);
    printf("---------------------------------------\n");
    printf("Concentration Units (environmental)\n");
    printf("PM 1.0: %u", data.pm10_env);
    printf("\t\tPM 2.5: %u", data.pm25_env);
    printf("\t\tPM 10: %u\n", data.pm100_env);
    printf("---------------------------------------\n");
    printf("Particles > 0.3um / 0.1L air: %u\n", data.particles_03um);
    printf("Particles > 0.5um / 0.1L air: %u\n", data.particles_05um);
    printf("Particles > 1.0um / 0.1L air: %u\n", data.particles_10um);
    printf("Particles > 2.5um / 0.1L air: %u\n", data.particles_25um);
    printf("Particles > 5.0um / 0.1L air: %u\n", data.particles_50um);
    printf("Particles > 10.0 um / 0.1L air: %u\n", data.particles_100um);
    printf("---------------------------------------\n");
}

/******************************************************************************
 * Main
 *****************************************************************************/




int main() {
    //printf("Bienvenido");
    log("init tft \r\n");
    tft.init();
    
    //  uint16_t x = 0;
    //  uint16_t y = 0;
    uint16_t w = tft.width();
    uint16_t h = tft.height();
  
    //  bool down = false;
    //  bool lastDown = false;
    tft.setTextColor(0xFFFF,0xF81F);
    tft.drawString(35, 30, "Cantidad de particulas : ");
    //tft.drawString(70, 100, "Pm 2.5: ");
    tft.drawString(70, 150, "Pm 1.0: ");

    // This callback runs in an interrupt context, thus we debounce to the event queue here
    pm25.enable(queue.event(&pm25_data_callback));

    queue.dispatch_forever();
}
