


/*
 * enum for station or softAP moenum mode {AP, STA};
 */
 enum mode {AP, STA};
 
void setPCBaud(int baud);
void setESPBaud(int baud);

void espInit(void);

/**
 * Sets the mode to STA=1, AP=2 or BOTH=3
 * @param  mode The desired mode
 */
void setMode(const char* mode);

/**
 * Configure the softAP.
 * @param ssid  string parameter, SSID of AP
 * @param password  string parameter, length of password: 8 ~ 64 bytes ASCII
 * @param channel  channel ID.
 * @param encryption  encryption method; WEP is not supported.
            ‣ 0: OPEN
            ‣ 2: WPA_PSK
            ‣ 3: WPA2_PSK
            ‣ 4: WPA_WPA2_PSK
 */
void confAP(const char* ssid, const char* password, const char* channel, const char* encryption);

/**
 * sets the ip adress of STA or AP
 * @param  variable Description text text text.          (3)
 * @return Description text text text.
 */
void setIP(enum mode m, const char* ip);


void getIP(enum mode m);
void getConnSTAs(void);
void SendCMD(void);
void getreply(void);