#include "ESP8266.h"

#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial esp(PTC17, PTC16); //FRDM K64F 
Timer t1;

int  timeout,getcount=600,replycount;
char replybuff[1024];
char cmdbuff[255];

void setPCBaud(int baud){
    pc.baud(baud);
}
void setESPBaud(int baud){
    esp.baud(baud);
}

void espInit(void){
    wait(1);
    strcpy(cmdbuff,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    wait(1);
    
    pc.printf("\r\nReset & get Firmware\r\n");
    strcpy(cmdbuff,"AT+RST\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(replybuff);
    wait(2);

    pc.printf("\nGet Version\r\n");
    strcpy(cmdbuff,"AT+GMR\r\n");
    SendCMD();
    timeout=15;
    getreply();
    pc.printf(replybuff);
    wait(3);
}

void setMode(const char* mode){
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\nSetting Mode\r\n");
    strcpy(cmdbuff, "AT+CWMODE=");
    strcat(cmdbuff, mode);
    strcat(cmdbuff, "\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(replybuff);
    wait(2);
}

void confAP(const char* ssid, const char* password, const char* channel, const char* encryption){
    // configure softAP
    pc.printf("\n\rconfigure softAP\r\n");
    strcpy(cmdbuff, "AT+CWSAP_CUR=\"");
    strcat(cmdbuff, ssid);
    strcat(cmdbuff, "\",\"");
    strcat(cmdbuff, password);
    strcat(cmdbuff, "\",");
    strcat(cmdbuff, channel);
    strcat(cmdbuff, ",");
    strcat(cmdbuff, encryption);
    strcat(cmdbuff, "\r\n");
    SendCMD();
    timeout=150;
    getreply();
    pc.printf(replybuff);
    wait(2);
}

//set AP ip adress
void setIP(enum mode m, const char* ip){
    printf("\nSetting ip adress\r\n");
    strcpy(cmdbuff, "AT+CIP");
    strcat(cmdbuff, ((m==STA)?"STA":"AP") );
    strcat(cmdbuff, "_CUR=\"");
    strcat(cmdbuff, ip);
    strcat(cmdbuff, "\",\"192.168.0.1\",\"255.255.255.0\"\r\n");
    SendCMD();
    timeout=15;
    getreply();
    printf(replybuff);
    wait_ms(100);
}

void getIP(enum mode m){
    printf("\nQuery ip adress\r\n");
    strcpy(cmdbuff, "AT+CIP");
    strcat(cmdbuff, ((m==STA)?"STA":"AP") );
    strcat(cmdbuff, "_CUR?\r\n");
    SendCMD();
    timeout=15;
    getreply();
    printf(replybuff);
    wait_ms(100);    
}

//get Connected stations
void getConnSTAs(void){
    printf("\nget connected stations\r\n");
    strcpy(cmdbuff, "AT+CWLIF\r\n");
    SendCMD();
    timeout=10;
    getreply();
    printf(replybuff);
    wait(2);
}

void getreply(void){   
    memset(replybuff, '\0', sizeof(replybuff));
    t1.reset(); t1.start();replycount=0;
    while(t1.read_ms()< timeout && replycount < getcount) {
        if(esp.readable()) {
            replybuff[replycount] = esp.getc();replycount++;
            }
        }
    t1.stop();      
}

// ESP Command data send
void SendCMD(void){
    esp.printf("%s", cmdbuff);      
} 