#include    "mbed.h"
#include    "auto.h"

#define MARCHA_IZQ    0.70f //0.5
#define MARCHA_DER    0.3f //0.21
//MotorA en el auto 17, es el izquierdo
//MotorB en el auto 17, es el derecho


#define byte unsigned char

// Led del mbed para visualizar en este caso el eje Y del acelerometro
DigitalOut led4(LED4);
DigitalOut led3(LED3);
DigitalOut led2(LED2);
DigitalOut led1(LED1);

//Faroles delanteros
DigitalOut FarolA(p20);
DigitalOut FarolB(p30);

//Boton de uso general
InterruptIn Boton(p17);

// Puerto serie para mandar los datos del ADC.
Serial pc(USBTX, USBRX); // tx, rx

// Timeout para el debounce del boton.
Timeout debounce;


void check_boton (void) {

    if (Boton == 0) {
        FarolA = !FarolA;
        FarolB = !FarolB;
    }
    debounce.detach();
    Boton.fall(&handler_boton);//Paso por puntero el metodo a ejecutar cuando se tiende la interrupcion
}

void handler_boton(void) {

    debounce.attach(&check_boton, 0.015);
    Boton.fall(NULL);
}


class Zigbit
{
public:
    Zigbit();
    bool listen();
    byte getByte();
  // bool isCommand();
  // void getCommand(int* cmd, int* param);

private:
    Serial* zigbitCom;
    byte data;
};

// Constructor. Crea el puerto serie de comunicacion con el zigbit.
Zigbit::Zigbit()
{
    zigbitCom = new Serial(p13, p14);

    // Config serial del zigbit
    zigbitCom->baud(38400);
    zigbitCom->format(8, Serial::None, 1);   
}


bool Zigbit::listen()
{
    bool r= false;

    if (zigbitCom->readable())
    {
        data = zigbitCom->getc();
        r = true;
    }
   
    return r;   // Si hay algo en el buffer de Rx
}


byte Zigbit::getByte()
{
    return data;
}


int main()
{
    Zigbit cmdLink;
    
    // Config PWM
    Motor motorB (p22, p21, p23);
    Motor motorA (p25, p24, p26);

    // Config sensores
    Sensor sensorA (p9, p19);
    Sensor sensorB (p10, p18);
    // Prendo las altas

    FarolA = 1;
    FarolB = 1;

    // Asocio el handler con el boton
    Boton.mode(PullUp);

    // Boton.fall(&handler_boton);
    while(Boton==1){}

    // Configuro motor A
    motorA.set_sentido(ADELANTE);
    motorA.Velocidad = MARCHA_IZQ;

    // Configuro motor B
    motorB.set_sentido(ADELANTE);
    motorB.Velocidad = MARCHA_DER;

    byte cmd = 0;

    while (1)
    {
        if (cmdLink.listen())
            cmd = cmdLink.getByte();

        switch (cmd)
        {
            case 1:

                motorA.set_sentido(ADELANTE);
                motorA.Velocidad = MARCHA_IZQ;
                motorB.set_sentido(ADELANTE);
                motorB.Velocidad = MARCHA_DER;
                break;

            case 2:

                motorA.set_sentido(ATRAS);
                motorA.Velocidad = MARCHA_IZQ;
                motorB.set_sentido(ATRAS);
                motorB.Velocidad = MARCHA_DER;
                break;

            case 3: // Dobla a la derecha

                motorA.set_sentido(ADELANTE);
                motorA.Velocidad = MARCHA_IZQ;
                motorB.set_sentido(ADELANTE);
                motorB.Velocidad = MARCHA_DER*0.3;
                break;

           
            case 4: //Rota a derecha

                motorA.set_sentido(ADELANTE);
                motorA.Velocidad = MARCHA_IZQ*0.6;
                motorB.set_sentido(ATRAS);
                motorB.Velocidad = MARCHA_DER*0.6;
                break;

            
            case 5: // Dobla a la izquierda

                motorA.set_sentido(ADELANTE);
                motorA.Velocidad = MARCHA_IZQ*0.16;
                motorB.set_sentido(ADELANTE);
                motorB.Velocidad = MARCHA_DER;
                break;

            case 6: //Rota a izquierda
            
                motorA.set_sentido(ATRAS);
                motorA.Velocidad = MARCHA_IZQ*0.6;
                motorB.set_sentido(ADELANTE);
                motorB.Velocidad = MARCHA_DER*0.6;
                break;
                
            case 7: //Rota a derecha, atras

                motorA.set_sentido(ATRAS);
                motorA.Velocidad = MARCHA_IZQ*0.6;
                motorB.set_sentido(ADELANTE);
                motorB.Velocidad = MARCHA_DER*0.6;
                break;

            
            case 8: //Rota a izquierda, atras
            
                motorA.set_sentido(ADELANTE);
                motorA.Velocidad = MARCHA_IZQ*0.6;
                motorB.set_sentido(ATRAS);
                motorB.Velocidad = MARCHA_DER*0.6;
                break;
            
            case 9:

                motorA.set_sentido(DETENIDO);
                motorB.set_sentido(DETENIDO);
                break;
            
            case 10: //Modo seguidor de lineas
            
                if (sensorA.get_color() == BLANCO && sensorB.get_color() == BLANCO) {

                  //  led1 = 0;
                  //  led2 = 1;
                  //  led4 = 0;
                  //  led3 = 1;
                    motorA.set_sentido(ADELANTE);
                    motorB.set_sentido(ADELANTE);

                } else if (sensorA.get_color() == BLANCO && sensorB.get_color() != BLANCO) {
        
                  //  led4 = 1;
                  //  led3 = 0;
                    motorA.set_sentido(ATRAS);
                    motorB.set_sentido(ADELANTE);
        
                } else if (sensorA.get_color() != BLANCO && sensorB.get_color() == BLANCO) {
        
                  //  led1 = 1;
                  //  led2 = 0;
                    motorA.set_sentido(ADELANTE);
                    motorB.set_sentido(ATRAS);
                }
                   
                break;
                
        }
    }
}