#include "mbed.h"
#include "i2c_accelerometer.h"

DigitalOut myled(LED1);

DigitalOut LA(LED1);
DigitalOut LB(LED2);
DigitalOut LC(LED3);
DigitalOut LD(LED4);

int activo = 1;

Serial zigbitCom(p13, p14);
Serial pc(USBTX, USBRX); 

DigitalIn botonIzq(p19);
DigitalIn botonDer(p20);


void iluminar() {
    LA = LB = LC = LD = 0;
    switch (activo) {
        case 1:
            LA = 1;
            break;
        case 2:
            LB = 1;
            break;
        case 3:
            LC = 1;
            break;
        case 4:
            LD = 1;
            break;
    }
}

void cambiarLeds(float x) {
    
    int vel = (int)(x*10);
    
    if ((vel > 0) && (vel < 6))    activo = 3;
    if ((vel > 5) && (vel < 10))   activo = 4;
    if ((vel > -6) && (vel < 0))   activo = 2;
    if ((vel > -10) && (vel < -5)) activo = 1;
 
    iluminar();
}

// Determina el comando a enviar en funcion de la posicion del acelerometro y los botones
int rango(float *vect)
{
   int r;
       
   int velY = (int)(vect[1]*10);
   int velZ = (int)(vect[2]*10);
   
   if ((velY >= -2) && (velY <= 2)) {
      if (velZ <= -3 && velZ >= -10) r = 2; //Ir atras
      else r = 1; //Ir adelante
   }   
   if ((velY > 2) && (velY <= 6)) r = 5; //Doblar a izquierda, adelante
   if ((velY > 6) && (velY <= 10)) {
      if (velZ <= -3 && velZ >= -10) r = 7; //Rotar a derecha, atras
      else r = 6; //Rotar a izquierda, adelante
   }   
   if ((velY >= -6) && (velY < -2)) r = 3; //Doblar a derecha, adelante
   if ((velY >= -10) && (velY < -6)) {
      if (velZ <= -3 && velZ >= -10) r = 8; //Rotar a izquierda, atras
      else r = 4; //Rotar a derecha, adelante
   }  
    
   if (botonDer == 0) r = 9;  //Detener
   if (botonIzq == 0) r = 10; // Entrar en modo linea (manteniendo apretado)
        
   return r;
}

/*int rango(float *vect)
{
   int r;
         
   int velY = (int)(vect[1]*10);
   int velZ = (int)(vect[2]*10);
   
   if ((velY >= -2) && (velY <= 2))     r = 1; //Ir adelante
   if ((velY > 2) && (velY <= 6))       r = 5; //Doblar a izquierda
   if ((velY > 6) && (velY <= 10))      r = 6; //Rotar a izquierda
   if ((velY >= -6) && (velY < -2))     r = 3; //Doblar a derecha
   if ((velY >= -10) && (velY < -6))    r = 4; //Rotar a derecha
    
   if (velZ <= -3 && velZ >= -10) r = 2; //Ir atras
    
   if (botonDer == 0) r = 9; //Detenido --> 7
   if (botonIzq == 0) r = 10; // Entrar en modo linea (manteniendo apretado) --> 8
        
   return r;
}*/


void actualizarAuto(float *vect) {

    int comando = rango(vect);
    //int comando = rango(vect);
  
    zigbitCom.putc(comando);
}

void actualizarEstado(float *vect) {
    pc.printf("%0.2f; %0.2f; %0.2f\n", vect[0], vect[1], vect[2]);
}// Muestra el estado de los 3 ejes en una terminal serie


int main() {
    // Config serial del zigbit
    wait(1);//Para que tenga unos segundos para estabilizarse antes de calibrar
    Accelerometer acer; // se crea la instancia del objeto acelerometro e inicializa el mismo
    pc.baud(57600);
    
    float vect[3];
    /*int *flagDer;
    int *flagIzq;
    *flagDer = 0;
    *flagIzq = 0;*/
    
    zigbitCom.baud(38400);
    zigbitCom.format(8, Serial::None, 1);   
    
    botonIzq.mode(PullUp);
    botonDer.mode(PullUp);
       
    while(1)
    {
        acer.get10BitVector(vect);
        cambiarLeds(vect[1]);
        actualizarEstado(vect);
        //actualizarAuto(vect);
        actualizarAuto(vect);//, flagDer, flagIzq);
        wait(0.3);
           
    }    
}
