ADI Sense 1000 Overview
=======================

[TOC]

ADI Sense 1000
--------------

# Overview {#overview}
The ADI Sense 1000 is a first-generation ADI Sense measurement processor which
combines high-precision analog sensor inputs, SPI/I2C digital I/O interfaces
and integrated DSP algorithms which transform the raw sensor input data into
measurement values expressed in standard units ready for application use.

The ADI Sense 1000 processor is designed to run as a slave device, connected
to and controlled by a separate host application processor.

The ADI Sense Host Application library currently includes support for the
ADI Sense 1000 processor module, used in conjuction with the ST Nucleo F411RE
host application processor running Mbed OS.  Support for additional ADI Sense
modules and host application processor platforms will be added in the future.

# Interfaces {#interfaces}
## Host Communication Interfaces {#interfaces_hostcommunication}
The interfaces in this section enable the connectivity with the host application
processor which is responsible for configuration and control of the ADI Sense
1000 device.  Platform-specific host connection parameters may be specified via
the [ADI_SENSE_CONNECTION](@ref ADI_SENSE_CONNECTION) structure on the
[ADI Sense API](@ref ADI_Sense_Api) and low-level connectivity is accessed
via the [ADI Sense Host Portability Layer](@ref ADI_Sense_Host).

* SPI
  + Standard 4-wire SPI interface (SCLK, MOSI, MISO, SS)
  + Mode 0 (CPOL=0, CPHA=0)
  + SCLK speeds up to 1.6MHz
* Signals
  + ERROR
    - active-high digital output
    - signals an unrecoverable error condition to the host processor
  + ALERT
    - active-high digital output
    - signals a warning/alert condition to the host processor
  + DATAREADY
    - active-high digital output
    - signals a data ready condition to the host processor
  + RESET
    - active-low digital input
    - pulse low for at least 4 microseconds to trigger a hardware reset of the module

## Sensor Interfaces {#interfaces_sensor}
The following is an overview of the sensors interfaces available on the ADI Sense 1000
module.  For latest information on the sensors currently supported by this library,
please refer to the [ADI Sense 1000 API](@ref ADI_Sense_1000_Api)

* Analog Sensor Interfaces
  + CJC 1-2
    - Intended for connecting 2-wire reference temperature sensors
    - Analog sensor types currently supported:
      - 2-wire PT100 RTD
      - 2-wire PT1000 RTD
  + SENSOR 0-3
    - Intended for connecting a wide variety of precision analog sensors
    - Analog sensor types currently supported:
      - 2/3/4-wire PT100 RTD temperature sensors
      - 2/3/4-wire PT1000 RTD temperature sensors
      - Type-T/K/J Thermocouple temperature sensors
      - 4/6-wire bridge tranducer temperature/pressure sensors
      - 10k NTC Thermistor temperature sensors
  + I\_MEAS
    - Intended for connecting 4-20mA analog current sensors
  + V\_MEAS
    - Intended for connecting 0-10V analog voltage sensors
* Digital Sensor Interfaces
  + SPI
    - Intended for connecting support SPI digital sensors
    - SPI digital sensor types currently supported:
      - Honeywell TruStability HSC pressure sensors
      - Analog Devices ADXL362 3-Axis MEMS accelerometer
  + I2C
    - Intended for connecting support SPI digital sensors
    - SPI digital sensor types currently supported:
      - Honeywell HumidIcon HIH9000 Series humidity sensors
      - Sensirion SHT3x Series humidity sensors

## Ancillary Interfaces {#interfaces_ancillary}
* External Reference Inputs
  + REF 1-2
    - Optional external reference inputs, for use with analog sensors
* Voltage Reference Outputs
  + AVDD
    - Analog voltage reference output (typically 3.3V)
  + VDD
    - Digital voltage reference output (typically 3.3V)

