//Sean Lane, 100648027, 11/03/2020
//A6_2: PWM and Servo Control

#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2) ;
DigitalOut myled3(LED3) ;
DigitalOut myled4(LED4) ;
InterruptIn b2S(p17) ;
PwmOut servo(p21);
AnalogIn photoIn(p20) ;
InterruptIn b1S(p18) ;
AnalogIn thermIn(p19) ;
Serial pc(USBTX,USBRX);

void illumLEDs(int nmleds)
{
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;

    if (nmleds > 0) { 
        myled1 = 1 ; }
    if (nmleds > 1) {
        myled2 = 1 ; }
    if (nmleds > 2) { 
        myled3 = 1 ; }
    if (nmleds > 3) { 
        myled4 = 1 ; }
}

void dispAng(float angle)
{
     int nmleds = 0 ;
     if ( angle == 0.0 ) nmleds = 1 ;
     else if ( angle <= 90.0 ) nmleds = 2 ;
     else if ( angle < 180.0 ) nmleds = 3 ;
     else if ( angle == 180.0 ) nmleds = 4 ;
     illumLEDs(nmleds) ;
}

void printUsage(char mode)
{
     pc.printf("\n") ;
     pc.printf("Use button #2 to cycle servo control between \n") ;
     pc.printf("  1) Push-button control via button#1, \n") ;
     pc.printf("  2) Light intensity control via photocell on pin20 \n") ;
     pc.printf("  3) Temperature control via thermistor on pin19, \n") ;
     pc.printf("\n") ;
     pc.printf("Mode is [%c] \n", mode) ;
     pc.printf("\n") ;

     // Print out MODE appropriate instructions

     if (mode == 'B')
     {
         pc.printf("Press button #1 move the servo 30 degrees. Once it hits \n") ;
         pc.printf("180 degrees, it will return to 0. Holding button #1 down \n") ;
         pc.printf("for 3s or longer will reset the servo position to 0.\n") ;
         pc.printf("\n") ;
     }
     else if (mode == 'P')
     {
         pc.printf("The photocell now controls the servo position. \n") ;
         pc.printf("  - Brighter light will move the servo towards 180 degrees \n") ;
         pc.printf("  - Ambient light will move the servo towards 90 degrees \n") ;
         pc.printf("  - Dim conditions will move the servo towards 0 degrees \n") ;
         pc.printf("\n") ;
     }
     else
     {
         pc.printf("The thermistor now controls the servo position. \n") ;
         pc.printf("  - Higher temps will move the servo towards 180 degrees \n") ;
         pc.printf("  - Lower temps will move the servo towards 0 degrees \n") ;
         pc.printf("\n") ;
     }

     pc.printf("\n") ;
}


void servo_test(float period, float minPulse, float maxPulse, float
pulseStep)
{
     float currentPulse;
     servo.period(period); //set the PWM period
     pc.printf("Commencing Servo Test\r\n");
     for (currentPulse=minPulse; currentPulse<maxPulse; currentPulse=currentPulse+pulseStep) {
         servo.pulsewidth(currentPulse/1000000.000); //convert uSec to sec.
         pc.printf("Current pulse width is %f\r\n",currentPulse);
         wait(0.5);
     }
     pc.printf("Servo Test Finished\r\n");
}

void servo_set_angle(float angle)
{
     pc.printf("Setting servo angle to: %5.2f \n", angle) ;
     float pulseCoeff = 10.0;
     float pulseOffset = 400;
     float pulseWidth;
     if (angle < 0) {
         angle = 0;
     } else if (angle > 180) {
         angle = 180.0;
     }

     pulseWidth = pulseCoeff * angle + pulseOffset;
     servo.pulsewidth(pulseWidth/1000000.000);

     dispAng(angle) ;
}

float servo_ang;



void servoInit(bool testServo)
{

     if ( testServo ) servo_test(0.01,0,3000,50);
     servo.period(0.01) ;
     servo_ang = 0 ;

     servo_set_angle(servo_ang) ;
}

Ticker b1PT ;
Timer b1SDebounce ;


void b1HH()
{
     b1PT.detach() ;
     servo_ang = 0.0 ;
     servo_set_angle(servo_ang) ;
}

void b1PH()
{
     if (b1SDebounce.read_ms() > 20)
     {
         b1SDebounce.reset() ;

         servo_ang += 30.0 ;
         if (servo_ang > 180.0) servo_ang = 0.0 ;

         servo_set_angle(servo_ang) ;

         // Set the ticker to fire after 3.0 seconds
         b1PT.attach(&b1HH, 3.0) ;
     }
}


void b1RH()
{
     if (b1SDebounce.read_ms() > 20)
     {
         b1SDebounce.reset() ;

         b1PT.detach() ;
     }
}

void b1E()
{
     pc.printf("** ENABLING BUTTON-1 CONTROL ** \n") ;
     b1SDebounce.start() ;
     b1S.rise(&b1PH) ;
     b1S.fall(&b1RH) ;
}

void b1Dis()
{
     pc.printf("** DISABLING BUTTON-1 CONTROL ** \n") ;
     b1SDebounce.stop() ;
     b1S.rise(0) ;
     b1S.fall(0) ;
}

Ticker photoRP ;

void readPhotoVoltage()
{
     float Rs = 10000.0 ;
     float Vs = 3.3 * photoIn.read() ;
     float I = ( Vs / Rs ) ;

     float Rcell = 3.3 * (Rs / Vs) - Rs ;

     float Rmax = 300000.0 ;
     float Rmin = 100.0 ;

     if (Rcell > Rmax) Rcell = Rmax ;
     if (Rcell < Rmin ) Rcell = Rmin ;

     float my_angle ;
     float lip ;

     if (0)
     {
         lip = ( Rcell - Rmin ) / (Rmax - Rmin) ;
         lip = 1.0 - lip ;
         pc.printf("  ** using direct values \n") ;
     }


     else
     {
         float logMin = log(Rmin) ;
         float logMax = log(Rmax) ;

         lip = (log(Rcell) - logMin) / (logMax - logMin) ;
         lip = 1 - lip ;
     }

     my_angle = 180 * lip ;

     if (my_angle < 0.0) my_angle = 0.0 ;
     else if (my_angle > 180.0) my_angle = 180.0 ;

     servo_ang = my_angle ;
     servo_set_angle(servo_ang) ;
}


void photoRE()
{
     pc.printf("** ENABLING PHOTOCELL CONTROL ** \n") ;
     // Sample the photoresistor every 2.0 seconds
     photoRP.attach(&readPhotoVoltage, 2.0) ;
}

void photoRD()
{
     pc.printf("** DISABLING PHOTOCELL CONTROL ** \n") ;
     photoRP.detach() ;
}

Ticker thermP ;

float convVT(float voltage)
{
     float C1 = 1481.96 ;
     float C2 = 2196200.0 ;
     float C3 = 1.8639 ;
     float C4 = 0.00000388 ;
     float tempC = sqrt(C2 + ((C3 - voltage) / C4)) - C1 ;
     return tempC ;
}

void readThermVoltage()
{
     float Vin = 3.3 * thermIn.read() ;
     float Tcelsius = convVT(Vin) ;

     float Tmax = 37.4 ;
     float Tmin = 20.0 ;

     // Establish hish and low values
     if (Tcelsius >= Tmax) Tcelsius = Tmax ;
     if (Tcelsius <= Tmin) Tcelsius = Tmin ;

     float percentage = (Tcelsius - Tmin) / (Tmax - Tmin) ;
     servo_ang = 180 * percentage ;
     servo_set_angle(servo_ang) ;
}


void thermistorEnable()
{
     pc.printf("** ENABLING THERMISTOR CONTROL ** \n") ;

     thermP.attach(&readThermVoltage, 2.0) ;
}

void thermistorDisable()
{
     pc.printf("** DISABLING THERMISTOR CONTROL ** \n") ;
     thermP.detach() ;
}


Ticker b2PT ;
Timer b2SDebounce ;

char currentMode = 0 ; 

void b2PH()
{
     if (b2SDebounce.read_ms() > 20)
     {
         b2SDebounce.reset() ;

         if (currentMode == 'B')
         {
             b1Dis() ;
             currentMode = 'P' ;
             photoRE() ;
         }
         else if (currentMode == 'P')
         {
             photoRD() ;
             currentMode = 'T' ;
             thermistorEnable() ;
         }
         else
         {
             thermistorDisable() ;
             currentMode = 'B' ;
             b1E() ;
         }

         printUsage(currentMode) ;
     }
}

void b2Init()
{
     currentMode = 'B' ;
     b2SDebounce.start() ;
     b2S.rise(&b2PH) ;
}

int main()
{
     wait(3);
     servoInit(false) ;
     b2Init() ;
     b1E() ;
     printUsage(currentMode) ;
     while(1) {
         wait(250) ;
     }
}