#include "mbed.h"

// SPI to the MRF89X.
SPI spi(PTD2, PTD3, PTD1); // mosi, miso, sclk
DigitalOut cs_fifo(PTC12);
DigitalOut cs_conf(PTC17);
DigitalIn mrf_reset(PTA16); // Hi-Z
DigitalIn mrf_irq0(PTC16);
DigitalIn mrf_irq1(PTC13);

// RGB LED.
PwmOut rled(LED_RED);
PwmOut gled(LED_GREEN);
PwmOut bled(LED_BLUE);

Serial pc(USBTX, USBRX);

// Local copy of MTF89X register contents.
unsigned char regs[32];
unsigned char regs2[32];

int main() {
    // Deselect chip select.
    cs_fifo = 1;
    cs_conf = 1;

    // RGB: Red
    rled = 0.5;
    gled = 1;
    bled = 1;
    
    // Setup the spi for 8 bit data mode 0.
    spi.format(8, 0);
    spi.frequency(1000000);

    // RGB: Orange
    rled = 0.5;
    gled = 0.5;
    bled = 1;

    // Read the MRF registers.    
    const unsigned char start = 0x00; // Bit 0
    const unsigned char read = 0x40; // Bit 1
    const unsigned char stop = 0x00; // Bit t
    cs_conf = 0;
    for (unsigned char addr = 0; addr < 32; addr++) {
      spi.write(start | read | (addr << 1) | stop);
      regs[addr] = spi.write(0);
    }
    cs_conf = 1;
    wait_ms(10);
    cs_conf = 0;
    for (unsigned char addr = 0; addr < 32; addr++) {
      spi.write(start | read | (addr << 1) | stop);
      regs2[addr] = spi.write(0);
    }
    cs_conf = 1;

    for (unsigned char addr = 0; addr < 32; addr++) {
      pc.printf("%02X A %02X B %02X\r\n", addr, regs[addr], regs2[addr]);
    }

    // RGB: green.
    rled = 1;
    gled = 1;
    bled = 1;
    while(1) {
        gled = 0.5;
        wait(0.2);
        gled = 1;
        wait(0.2);
    }
}