#include "mbed.h"

#include "max32625pico.h"
#include "max14750.h"

#include "USBSerial.h"
USBSerial serial;

static DigitalOut rLED(LED1);
static DigitalOut gLED(LED2);
static DigitalOut bLED(LED3);


void readMax14750Regs(MAX14750* max14750) {
    char regs[0x20] = {};
    if (max14750->readRegs(regs) != E_NO_ERROR) return;
    for (int i = 0; i < 32; i++) {
        serial.printf("%02X:%02X ", i, (int)regs[i]);
    }
    serial.printf("\r\n");
    MAX14750::chip_t chipType = max14750->identify(regs);
    switch(chipType) {
    case MAX14750::MAX14750A: serial.printf("MAX14750A\r\n"); break;
    case MAX14750::MAX14750B: serial.printf("MAX14750B\r\n"); break;
    case MAX14750::MAX14750C: serial.printf("MAX14750C\r\n"); break;
    case MAX14750::MAX14720A: serial.printf("MAX14720A\r\n"); break;
    case MAX14750::MAX14720B: serial.printf("MAX14720B\r\n"); break;
    case MAX14750::MAX14720C: serial.printf("MAX14720C\r\n"); break;
    case MAX14750::MAX14720D: serial.printf("MAX14720D\r\n"); break;
    }
    if ((chipType == MAX14750::MAX14750A) ||
        (chipType == MAX14750::MAX14750B) ||
        (chipType == MAX14750::MAX14750C)) {
        serial.printf("SWIN: %s\r\n", regs[0x1B] & 8? "high": "low");
        serial.printf("HVEN: %s\r\n", regs[0x1B] & 4? "high": "low");
        serial.printf("BEN:  %s\r\n", regs[0x1B] & 2? "high": "low");
        serial.printf("LEN:  %s\r\n", regs[0x1B] & 1? "high": "low");
    }
}

int main()
{
    rLED = LED_ON;
    gLED = LED_ON;
    bLED = LED_OFF;

    MAX32625PICO pico(
        MAX32625PICO::IOH_3V3, MAX32625PICO::VIO_IOH, MAX32625PICO::VIO_IOH);

    MAX14750 max14750;
    max14750.init(P3_4, P3_5);

    rLED = LED_OFF;
    gLED = LED_OFF;

    while(1) {
        char c = serial.getc();
        serial.printf("%c\r\n", c);
        if (c == 'v') {
            max14750.startBatV();
        } else {
            readMax14750Regs(&max14750);
        }
    }
}