/* mbed USBJoystick Library Demo
 * Copyright (c) 2012, v01:  Initial version, WH,
 *                           Modified USBMouse code ARM Limited.
 *                           (c) 2010-2011 mbed.org, MIT License
 *               2016, v02:  Updated USBDevice Lib, Added waitForConnect, Updated 32 bits button 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, inclumosig without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUmosiG BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "USBJoystick.h"
#include "QEI.h"

//#define LANDTIGER 1

//USBMouse mouse;
USBJoystick joystick;

// Variables for Heartbeat and Status monitoring
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

InterruptIn button(USER_BUTTON);
volatile bool send=true;

Ticker heartbeat;
Serial pc(USBTX, USBRX); // tx, rx

//Use X4 encoding.
QEI wheel(PA_6, PA_7, NC, 1000, QEI::X4_ENCODING);

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeatLED=1;
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}

void handlerbutton()
{
    send=!send;
}


int main() {
  uint16_t i = 0;
  int16_t throttle = 0;
  int16_t rudder = 0;    
  int16_t x = 0;
  int16_t y = 0;
  int32_t radius = 120;
  int32_t angle = 0;
  uint8_t tmp = 0;
  uint32_t buttons = 0;    
  uint8_t hat = 0;    
  int16_t k = 0;
    
  pc.printf("Hello World from Joystick!\n\r");

  heartbeat_start();
  button.rise(&handlerbutton);

  while (1) {
    // Basic Joystick
    //throttle = (i >> 8) & 0xFF; // value -127 .. 128
    //rudder = (i >> 8) & 0xFF;   // value -127 .. 128
    if(send == true){
        i = 0;
        k = (i >> 8) & 0x0F;
        pc.printf("OK TRUE!  %d \n\r",k);
    }
    else{
        i = 256;
        k = (i >> 8) & 0x0F;
        pc.printf("OK FAUSE! %d \n\r",k);
    }

#if (BUTTONS4 == 1)        
    buttons = (i >> 8) & 0x0F;   // value    0 ..  15, one bit per button     
#endif        
#if (BUTTONS8 == 1)        
    //buttons = (i >> 8) & 0xFF;   // value    0 .. 255, one bit per button     
#endif        
#if (BUTTONS32 == 1)        
    //tmp     = (i >> 8) & 0xFF;   // value    0 .. 255, one bit per button     
    //buttons =           (( tmp <<  0) & 0x000000FF);
    //buttons = buttons | ((~tmp <<  8) & 0x0000FF00);
    //buttons = buttons | (( tmp << 16) & 0x00FF0000);
    //buttons = buttons | ((~tmp << 24) & 0xFF000000);
#endif        

#if (HAT4 == 1)        
    //hat    = (i >> 8) & 0x03;   // value 0, 1, 2, 3 or 4 for neutral 
#endif
#if (HAT8 == 1)
    //hat    = (i >> 8) & 0x07;   // value 0..7 or 8 for neutral
#endif        
    //i++;        
        
    //x = cos((double)angle*3.14/180.0)*radius;  // value -127 .. 128
    //y = sin((double)angle*3.14/180.0)*radius;  // value -127 .. 128
    //angle += 3;
    x = wheel.getPulses();
    x = x/4;
    joystick.update(throttle, rudder, -x, y, buttons, hat);
    wait(0.001);
  }
    
  pc.printf("Bye World!\n\r");                           
}