#include "main.h"
#include "mbed.h"

/**
 * Define I2C addresses for the device
 */
#define HY3116_ADDRESS 0xA0
#define RESET_ADDRESS  0x00

/**
 * Define settings & I2C command registers
 */
#define SYS     0x00
#define ADC1    0x01
#define ADC2    0x02
#define ADC3    0x03
#define ADC4    0x04
#define ADO     0x05
#define RESET   0x06

/**
 * HY3116 class definition
 */
class HY3116 
{
public:
    HY3116();
    HY3116(PinName sda, PinName scl);
    HY3116(PinName sda, PinName scl, int freq);
    ~HY3116();
    uint8_t readAdc(int32_t *_adcReading);
    bool init();
    
private:
    I2C i2c;
    
    int writeRegister(uint8_t regAddress, uint8_t data);
    int readRegister(uint8_t regAddress, uint8_t byteNum, uint8_t* dest);
    int resetChip();
};
