/*******************************************************************************
* Copyright (C) 2019 Maxim Integrated Products, Inc., All rights Reserved.
*
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#ifndef MAX41463_4_REGS_H_
#define MAX41463_4_REGS_H_

/**
 * @brief CFG1  (0x00)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char modmode    : 1;    /**< Configures modulator mode */
        unsigned char sync       : 1;    /**< Controls if clock output acts as an input.
                                              When an input, it will sample the DATA pin. */
        unsigned char fskshape   : 1;    /**< Sets the state of FSK Gaussian Shaping */
        unsigned char            : 1;
        unsigned char xoclkdiv   : 2;    /**< XO clock division ratio for digital block */
        unsigned char xoclkdelay : 2;    /**< Start delay before enabling XO clock to digital block */
    } bits;
} max41463_4_reg_cfg1_t;

/**
 * @brief CFG2  (0x01)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char bclk_postdiv : 3;    /**< Select the Baud Clock Post Division Ratio.
                                                Valid values are from 1 to 5. */
        unsigned char              : 3;
        unsigned char clkout_delay : 2;    /**< Selects the delay when CLKOUT starts toggling upon
                                                exiting SHUTDOWN mode, in divided XO clock cycles */
    } bits;
} max41463_4_reg_cfg2_t;

/**
 * @brief CFG3  (0x02)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char bclk_prediv : 8;    /**< Baud clock predivision ratio. Valid values are from 3 to 255 */
    } bits;
} max41463_4_reg_cfg3_t;

/**
 * @brief CFG4  (0x03)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pwdn_mode : 2;    /**< Power Down Mode Select */
        unsigned char           : 6;
    } bits;
} max41463_4_reg_cfg4_t;

/**
 * @brief CFG5  (0x04)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tstep : 6;    /**< Controls GFSK shaping. See Digital FSK Modulation section. */
        unsigned char       : 2;
    } bits;
} max41463_4_reg_cfg5_t;

/**
 * @brief SHDN  (0x05)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pa_boost        : 1;    /**< Enables a boost in PA output power for frequencies above 850MHz.
                                                  This requires a different PA match compared to normal operation. */
        unsigned char                 : 7;
    } bits;
} max41463_4_reg_shdn_t;

/**
 * @brief PA1  (0x06)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char papwr  : 3;    /**< Controls the PA output power by enabling parallel drivers. */
        unsigned char        : 5;
    } bits;
} max41463_4_reg_pa1_t;

/**
 * @brief PA2  (0x07)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pacap     : 5;    /**< Controls shunt capacitance on PA output in fF. */
        unsigned char           : 3;
    } bits;
} max41463_4_reg_pa2_t;

/**
 * @brief PLL1  (0x08)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char lomode      : 1;    /**< Sets LO generation. For lower power, choose LOWCURRENT.
                                               For higher performance, choose LOWNOISE. */
        unsigned char lodiv       : 2;    /**<  */
        unsigned char loopbw      : 2;    /**< Write to 00 binary.Sets PLL loop bandwidth. */
        unsigned char fracmode    : 1;    /**< Sets PLL between fractional-N and integer-N mode. */
        unsigned char cplin       : 2;    /**< Sets the level of charge pump offset current for fractional N mode
                                               to improve close in phase noise.Set to DISABLED for integer N mode. */
    } bits;
} max41463_4_reg_pll1_t;

/**
 * @brief PLL2  (0x09)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char cpval            : 2;    /**< Sets Charge Pump Current */
        unsigned char                  : 4;
        unsigned char lcvco_fast_start : 1;    /**< Write to 0 binary.
                                                    Enables fast start of LC VCO because of bias filtering */
        unsigned char lcvco_pwr        : 1;    /**< Write to 0 binary. Controls power in LC VCO */
    } bits;
} max41463_4_reg_pll2_t;

/**
 * @brief CFG6  (0x0A)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char fourwire1 : 1;    /**<  */
        unsigned char spi_txen1 : 1;    /**<  */
        unsigned char i2c_txen1 : 1;    /**< Enables DATA transmission in I2C mode. Aliased address for I2C_TXEN1 */
        unsigned char           : 5;
    } bits;
} max41463_4_reg_cfg6_t;

/**
 * @brief PLL3  (0x0B)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char freq_23_to_16 : 8;    /**< FREQ value to PLL. LO frequency= FREQ<23:0>/2^16*fXTAL */
    } bits;
} max41463_4_reg_pll3_t;

/**
 * @brief PLL4  (0x0C)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char freq_15_to_8 : 8;    /**< FREQ value to PLL */
    } bits;
} max41463_4_reg_pll4_t;

/**
 * @brief PLL5  (0x0D)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char freq_7_to_0 : 8;    /**< FREQ value to PLL */
    } bits;
} max41463_4_reg_pll5_t;

/**
 * @brief PLL6  (0x0E)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char deltaf : 7;    /**< For FSK mode, MODMODE=1 and FSKSHAPE=0, sets the frequency deviation from the
                                          space frequency for the mark frequency. fDELTA = DELTAF[6:0] * fXTAL/ 8192 */
        unsigned char        : 1;
    } bits;
} max41463_4_reg_pll6_t;

/**
 * @brief PLL7  (0x0F)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char deltaf_shape : 4;    /**< For FSK mode, MODMODE = 1 and FSKSHAPE = 1, sets the frequency deviation
                                                from the space frequency for the mark frequency.
                                                fDELTA = DELTAF_SHAPE[3:0] * fXTAL / 81920 */
        unsigned char              : 4;
    } bits;
} max41463_4_reg_pll7_t;

/**
 * @brief CFG7  (0x10)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char fourwire2 : 1;    /**<  */
        unsigned char spi_txen2 : 1;    /**<  */
        unsigned char i2c_txen2 : 1;    /**< When set, enables DATA transmission in I2C mode.
                                             Aliased address for I2C_TXEN1 */
        unsigned char           : 5;
    } bits;
} max41463_4_reg_cfg7_t;

/**
 * @brief I2C1  (0x11)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pktlen_14_to_8 : 7;    /**< Packet Length */
        unsigned char pktlen_mode    : 1;    /**< Packet Length Mode */
    } bits;
} max41463_4_reg_i2c1_t;

/**
 * @brief I2C2  (0x12)
 *
 * Detailed explanation.
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pktlen_7_to_0 : 8;    /**< Packet Length */
    } bits;
} max41463_4_reg_i2c2_t;

/**
 * @brief I2C3  (0x13)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char i2c_tx_data : 8;    /**< Transmit data to be written into FIFO for I2C mode of operation.
                                               At this address, I2C register address will not auto increment within an
                                               I2C transaction burst, and subsequent writes will keep going to FIFO */
    } bits;
} max41463_4_reg_i2c3_t;

/**
 * @brief I2C4  (0x14)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tx_pktlen_14_to_8 : 7;    /**< Provides status information of bits transmitted
                                                     for the current packet */
        unsigned char pktcomplete       : 1;    /**< Indicates if Packet transmission is completed */
    } bits;
} max41463_4_reg_i2c4_t;

/**
 * @brief I2C5  (0x15)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tx_pktlen_7_to_0 : 8;    /**< Provides status information of bits transmitted
                                                    for the current packet */
    } bits;
} max41463_4_reg_i2c5_t;

/**
 * @brief I2C6  (0x16)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char fifo_words : 3;    /**< This field captures the number of locations currently filled in FIFO.
                                              Each location corresponds to 8-bit data word */
        unsigned char            : 1;
        unsigned char fifo_full  : 1;    /**< FIFO Full Status */
        unsigned char fifo_empty : 1;    /**< FIFO Empty Status */
        unsigned char oflow      : 1;    /**< FIFO Overflow status */
        unsigned char uflow      : 1;    /**< FIFO Underflow status */
    } bits;
} max41463_4_reg_i2c6_t;

/**
 * @brief CFG8  (0x17)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char softreset : 1;    /**< Places DUT into software reset. */
        unsigned char           : 7;
    } bits;
} max41463_4_reg_cfg8_t;

/**
 * @brief CFG9  (0x18)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char xoen     : 1;    /**< Write to 0 binary.XO Enable register for test purpose */
        unsigned char pllen    : 1;    /**< Write to 0 binary.PLL Enable register for test purpose */
        unsigned char paen     : 1;    /**< Write to 0 binary.PA Enable register for test purpose */
        unsigned char test_ana : 5;    /**< Write to 0_0000 binary.Test modes for analog block */
    } bits;
} max41463_4_reg_cfg9_t;

/**
 * @brief ADDL1  (0x19)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ring_bias : 2;    /**< Write to 00 binary. Controls the current mirror ratio in Ring Oscillator
                                             control.  For lower frequencies, the number can be reduced for slightly
                                             better phase noise. */
        unsigned char ring_trim : 2;    /**< Write to 00 binary.
                                             Adjusts the current control value for ring oscillator. */
        unsigned char bias_trim : 2;    /**< Write to 00 binary. Adjusts bias current for PLL block. */
        unsigned char xtal_gm   : 2;    /**< Write to 00 binary.
                                             Controls crystal oscillator GM current for startup time control */
    } bits;
} max41463_4_reg_addl1_t;

/**
 * @brief ADLL2  (0x1A)
 *
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char addlctrl2       : 7;    /**< Write to 000_0000 binary. Additional control fields for future use */
        unsigned char scl_stretch_dly : 1;    /**< Write to 1 binary. I2C SCL Stretch Release delay enable */
    } bits;
} max41463_4_reg_addl2_t;

/**
 * @brief Register Set
 *
 */
typedef struct {
    max41463_4_reg_cfg1_t reg_cfg1;
    max41463_4_reg_cfg2_t reg_cfg2;
    max41463_4_reg_cfg3_t reg_cfg3;
    max41463_4_reg_cfg4_t reg_cfg4;
    max41463_4_reg_cfg5_t reg_cfg5;
    max41463_4_reg_shdn_t reg_shdn;
    max41463_4_reg_pa1_t reg_pa1;
    max41463_4_reg_pa2_t reg_pa2;
    max41463_4_reg_pll1_t reg_pll1;
    max41463_4_reg_pll2_t reg_pll2;
    max41463_4_reg_cfg6_t reg_cfg6;
    max41463_4_reg_pll3_t reg_pll3;
    max41463_4_reg_pll4_t reg_pll4;
    max41463_4_reg_pll5_t reg_pll5;
    max41463_4_reg_pll6_t reg_pll6;
    max41463_4_reg_pll7_t reg_pll7;
    max41463_4_reg_cfg7_t reg_cfg7;
    max41463_4_reg_i2c1_t reg_i2c1;
    max41463_4_reg_i2c2_t reg_i2c2;
    max41463_4_reg_i2c3_t reg_i2c3;
    max41463_4_reg_i2c4_t reg_i2c4;
    max41463_4_reg_i2c5_t reg_i2c5;
    max41463_4_reg_i2c6_t reg_i2c6;
    max41463_4_reg_cfg8_t reg_cfg8;
    max41463_4_reg_cfg9_t reg_cfg9;
    max41463_4_reg_addl1_t reg_addl1;
    max41463_4_reg_addl2_t reg_addl2;
} max41463_4_reg_map_t;

#endif /* MAX41463_4_REGS_H_ */
