/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "Max4146x.h"
#include "Max41460_regs.h"
#include "Max41461_2_regs.h"
#include "Max41463_4_regs.h"

//using namespace MAX4146X<max41461_2_reg_map_t>;

int main()
{
    max41461_2_reg_map_t max41461_reg;
    I2C i2c(P5_7, P6_0);
    i2c.frequency(400000);
    
    MAX4146X<max41461_2_reg_map_t> max41461(&max41461_reg, &i2c);
    
    /*initial programming for MAX41462*/
    max41461.set_modmode(MAX4146X<max41461_2_reg_map_t>::MODMODE_ASK);
    max41461.set_i2c_txen1(MAX4146X<max41461_2_reg_map_t>::I2C_TXEN1_DISABLE);
    max41461.set_frequency(300000);
    max41461.set_i2c_txen2(MAX4146X<max41461_2_reg_map_t>::I2C_TXEN2_ENABLE);
    max41461.set_i2c_data(0);

    while(1) {
        wait(2);
    }
}

