#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "stdio.h"
#include "string.h"

//Used to Log to the PC
Serial pc(USBTX,USBRX);

//Input Pin for the Paddle Wheel Flow Meter
DigitalIn pulse(p8);

// Pin Outs for Solenoids
DigitalOut Ctrl(p9);
DigitalOut Ctrl2(p10);

//
#define PULSE_VOL 4.50 // More flow due to angle of paddle wheel Pour 1
#define PULSE_VOL2 6.75 // Less flow due to angle of paddle wheel Pour 2

//Function Declarations
void pourOne(float milliliters);
void pourTwo(float milliliters);

/*
    The main function opens a web socket client and listens for a preset series
    of recipies. If one is found, it calls functions to pour liquid.
*/
int main() {
    pc.printf("Starting BarBot!\r\n");
    
    // Close Both Solenoids
    Ctrl = 0;
    Ctrl2 = 0;
    
    // Receive Buffer
    char recv[30];
    char recipe[] = "Rum & Coke";
    char recipe2[] = "Whiskey Ginger";
    char recipe3[] = "Whiskey Neat";
    
    // Ethernet Interfacing
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n\r", eth.getIPAddress());
 
    // Open a Websocket
    Websocket ws("ws://sockets.mbed.org:443/ws/sid/ro"); //This Websocket server is provided by MBED for prototyping
    ws.connect();
    
    // Wait to receive an order from websocket
    while (1) {
        
        if(ws.read(recv)) {
            pc.printf("%s\r\n", recv);

            // Recipe based process
            if(strcmp(recv, recipe) == 0) {
                pourOne(132);
                pourTwo(44);    
            }
            else if(strcmp(recv, recipe2) == 0) {
                pourOne(0);
                pourTwo(88);   
            }
            else if(strcmp(recv, recipe3) == 0) {
                pourOne(88);
                pourTwo(0);
            }
        } 
        
        wait(1.0);
    }
    
}

void pourOne(float milliliters) {
    
    pc.printf("Pour One\r\n");
    
    //pouring an empty amount (neat drinks)
    if(milliliters <= 0) {
        return;    
    } 
    
    int pulses = 0;
    bool lastPulse = pulse;
    bool thisPulse;
    float volume = 0;
    
    //open solenoid one
    Ctrl = 1;
    
    while(volume < milliliters) {
        thisPulse = pulse;
        
        //check to see if pulse has changed since the last time
        if(thisPulse != lastPulse) {
            pulses += 1;    
        }
        lastPulse = thisPulse;
        
        //increase the volume
        volume = pulses * PULSE_VOL;
        
        pc.printf("Poured %f From First Bottle\r\n", volume);    
    }
    
    
    //close solenoid one
    Ctrl = 0;    
}

void pourTwo(float milliliters) {
    
    pc.printf("Pour Two\r\n");
    
    //pouring an empty amount (neat drinks)
    if(milliliters <= 0) {
        return;    
    } 
    
    int pulses = 0;
    bool lastPulse = pulse;
    bool thisPulse;
    float volume = 0;
    
    //open solenoid two
    Ctrl2 = 1;
    
    while(volume < milliliters) {
        thisPulse = pulse;
        
        //check to see if pulse has changed since last time
        if(thisPulse != lastPulse) {
            pulses += 1;    
        }
        
        lastPulse = thisPulse;
        
        //increase the volume
        volume = pulses * PULSE_VOL2;
        
        pc.printf("Poured %f From Second Bottle\r\n", volume);    
    }
    
    //close solenoid two
    Ctrl2 = 0;
}