#ifndef M3PI_POV
#define M3PI_POV

#include "mbed.h"
#include "m3pi.h"
#include "rtos.h"

class pov: public Stream {
    
public:

    /** Create the pov object connected to default pins.
    * 
    */
    pov();
    
    /** Create the pov object connected to specific pins.
    * 
    *   @param l1 LED 1. Default is p13.
    *   @param l2 LED 2. Default is p14.
    *   @param l3 LED 3. Default is p15.
    *   @param l4 LED 4. Default is p16.
    *   @param l5 LED 5. Default is p17.
    *   @param l6 LED 6. Default is p18.
    *   @param l7 LED 7. Default is p19.
    *   @param l8 LED 8. Default is p20.
    */
    pov(PinName l1, PinName l2, PinName l3, PinName l4, PinName l5, PinName l6,
            PinName l7, PinName l8);

    /** Initialise the POV display. Default right spin.
     *
     */
    void init(void);

    /** Initialise the POV display. 
     *
     *  @param spin A negative number for a spin to the left, a positive 
     *              number or 0 for a spin to the right.
     */
    void init(int spin);

    /** Stop the POV display.
     *
     */
    void stop(void);

    /** Display a string on the POV display.
     *
     *  @param text Text to display.
     */
    void display(char* text);

private:

    /** Get a the int array representation of a letter.
     *
     *  @param c The character to get the int array representation for.
     */
    char[] _get_char_arr(char c);

};


#endif //M3PI_POV
