#include "m3pi_pov.h"
#include "alphabet.h"

#define SPIN_SPEED 1.0
#define PIXEL_TIME 0.002

BusOut _leds;
m3pi m3pi;

int pov_display = 1; // flag for pov display while loop

pov::pov(PinName l1, PinName l2, PinName l3, PinName l4, PinName l5,
        PinName l6, PinName l7, PinName l8) {
    _leds(l8, l7, l6, l5, l4, l3, l2, l1);
}

pov:::pov() {
    _leds(p20, p19, p18, p17, p16, p15, p14, p13);
}


void pov::init(void) {
    m3pi.right(SPIN_SPEED);
}

void pov::init(int spin) {
    if (spin < 0) {
        m3pi.left();
    } else {
        m3pi.right();
    }
}

void pov::stop(void) {
    pov_display = 0;
    m3pi.stop();
}

void pov::display(char* text) {
    pov_display = 1;
    while (pov_display) {
        for (char* it = text; *it; ++it) {
            char[] arr = _get_char_arr(it);
            for (int i = 0; i < 6; i++) {
                char a = arr[i];
                _leds = (int) a;
                wait(PIXEL_TIME);
            }
        }
    }
}

char[] pov::_get_char_arr(char c) {
    int arr_loc = c - 32;
    return font[arr_loc];
}





