#include "mbed.h"
#include "VodafoneUSBModem.h"

#define MY_PHONE_NUMBER "+44xxxxxxxxxx"

void test(void const*) 
{
    VodafoneUSBModem modem;
    
    modem.sendSM(MY_PHONE_NUMBER, "Hello from mbed:)");

    while(true)
    {
        char num[17];
        char msg[64];
        size_t count;
        int ret = modem.getSMCount(&count);
        if(ret)
        {
          printf("getSMCount returned %d\n", ret);
          Thread::wait(3000);
          continue;
        }
        if( count > 0)
        {
          printf("%d SMS to read\n", count);
          ret = modem.getSM(num, msg, 64);
          if(ret)
          {
            printf("getSM returned %d\n", ret);
            Thread::wait(3000);
            continue;
          }
    
          printf("%s : %s\n", num, msg);
        }
        Thread::wait(3000);
    }
}


int main()
{
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
