
/*
Copyright (c) 2012 Mihail Stoyanov (wm [at] screamer [dot] org)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/


#ifndef LOG_H
#define LOG_H

#include "mbed.h"
#include "UDPSocket.h"


class Log {
    private:
        UDPSocket   sock;
        int         lPort;
        Host        lHost;
        Host        dHost;
        
        bool        is_init;

    public:
        ///Constructor
        /**
        @param port : local UDP bind port even though the logger doesn't acccept messages
        */
        Log (int port = 10000) {
            lPort = port;
        };
        
        ///The actual init method, which should be called after the ethernet is initialized
        /**
        @param pHost : the destination UDP server - Host dHost(IpAddr(1,2,3,4), port)
        
        Can be called multiple times to switch destination UDP servers
        */
        inline bool init(Host pHost) {
            Host lHost(IpAddr(), lPort);

            UDPSocketErr udpErr = sock.bind(lHost);
            if (udpErr != UDPSOCKET_OK) {
                printf("error %d\n", udpErr);
                return false;
            };

            dHost = pHost;
            is_init = true;
            
            return true;
        };
        
        ///The logging method.
        inline bool log(const char *msg) {
            if (!is_init) return false;

            int sent = sock.sendto(msg, strlen(msg), &dHost);
            if (sent < 0) {
                printf("error %d\n", (UDPSocketErr)sent);
            };
                
            return true;
        };
};

#endif