/**
 * @file    SensorDataParser.h
 * @brief   Parser for Sensor Data Streamer (binary) and Sensor Monitor (cvs) iPhone/Android apps
 * @author  Bogdan Marinescu & Mihail Stoyanov
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * Maximum number of processed CSV values
 */
#define MAX_CSV_VALS        40

/**
 * Processed data by parse_sensor_packet()
 */
typedef struct {
    float ax;       /**< Accelerometer X coordinate */
    float ay;       /**< Accelerometer Y coordinate */
    float az;       /**< Accelerometer Z coordinate */

    float gx;       /**< Gyroscope X coordinate */
    float gy;       /**< Gyroscope Y coordinate */
    float gz;       /**< Gyroscope Z coordinate */

    double tx;      /**< Teslameter X coordinate */
    double ty;      /**< Teslameter Y coordinate */
    double tz;      /**< Teslameter Z coordinate */
    
    double hm;      /**< Magnetic heading */
    double ht;      /**< True heading */

    double latitude;    /**< Latitude */
    double longitude;   /**< Longitude */
    double altitude;    /**< Altitude */
    
    int proximity;  /**< Proximity sensor */
    
    int touch1;     /**< Touch point 1 present */
    int touch1x;    /**< Touch point 1 X coordinate */
    int touch1y;    /**< Touch point 1 Y coordinate */

    int touch2;     /**< Touch point 1 present */
    int touch2x;    /**< Touch point 1 X coordinate */
    int touch2y;    /**< Touch point 1 Y coordinate */
} SENSOR_DATA;

/**
 * Parses a packet with sensor data.
 *
 * Currently supported packet formats:
 * - Sensor Data Streamer (binary)
 * - Sensor Monitor (csv)
 *
 * @param buf The packet contents
 * @param pd processed data
 *
 * @return 0 - Invalid packet type
 * @return 1 - Sensor Data Streamer packet
 * @return 2 - Sensor Monitor packet
 */
int parse_sensor_packet(char *buf, SENSOR_DATA *pd);
