//CD74HC4067 Library based on bildr code: "http://bildr.org/2011/02/cd74hc4067-arduino/"
//Ported to mbed by Scott M. O'Hair
//
//sample code:
/*
#include "mbed.h"
#include "CD74HC4067.h"

Serial pc(PB_6, PA_10, 115200); //tx, rx 

CD74HC4067 mux1(D8, D9, D12, D11, A0); //S0, S1, S2, S3, SIG
 
int main()
{
    pc.printf("Running MUX test\n");
    while(1) {
        //Loop through and read all 16 values
        for(int i = 0; i < 15; i++) {    
            mux1.currentState = mux1.readMux(i);
            if (fabs(mux1.portState[i] - mux1.currentState) > BTN_NOISE_THRES) { 
                pc.printf("Value at channel %i is %f\n", i, mux1.currentState);
                mux1.saveState(i, mux1.currentState);
            }
        }

    }
}
*/



#ifndef MBED_CD74HC4067_H
#define MBED_CD74HC4067_H
 
#include "mbed.h"
 
#define BTN_NOISE_THRES   0.018f            //Define a threshold for the amount of analog change required

class CD74HC4067 {
public:
    CD74HC4067(PinName S1, PinName S2, PinName S3, PinName S4, PinName SIG);
    void saveState(uint8_t port, float state);
    float readMux(uint8_t channel);
    float currentState ;
    float portState[16];
  
private:  
    DigitalOut _S0;
    DigitalOut _S1;
    DigitalOut _S2;
    DigitalOut _S3;
    AnalogIn _SIG;    

};
 
#endif