//CD74HC4067 Library based on bildr code: "http://bildr.org/2011/02/cd74hc4067-arduino/"
//Ported to mbed by Scott M. O'Hair

#include "CD74HC4067.h"
#include "mbed.h"


CD74HC4067::CD74HC4067(PinName S1, PinName S2, PinName S3, PinName S4, PinName SIG) : _S0(S1), _S1(S2), _S2(S3), _S3(S4), _SIG(SIG)
{
    //initialize port state to zero
    for (uint8_t i = 0; i < 15; i++) {
        portState[i] = 0.0;
    }

    //pull all pins low
    _S0 = 0;
    _S1 = 0;
    _S2 = 0;
    _S3 = 0;

}

void CD74HC4067::saveState(uint8_t port, float state)
{
    this->portState[port] = state;
}

float CD74HC4067::readMux(uint8_t channel)
{
    DigitalOut controlPin[] = {_S0, _S1, _S2, _S3};

    uint8_t muxChannel[16][4]= {
        {0,0,0,0}, //channel 0
        {1,0,0,0}, //channel 1
        {0,1,0,0}, //channel 2
        {1,1,0,0}, //channel 3
        {0,0,1,0}, //channel 4
        {1,0,1,0}, //channel 5
        {0,1,1,0}, //channel 6
        {1,1,1,0}, //channel 7
        {0,0,0,1}, //channel 8
        {1,0,0,1}, //channel 9
        {0,1,0,1}, //channel 10
        {1,1,0,1}, //channel 11
        {0,0,1,1}, //channel 12
        {1,0,1,1}, //channel 13
        {0,1,1,1}, //channel 14
        {1,1,1,1}  //channel 15
    };

    //loop through the 4 sig
    for(uint8_t i = 0; i < 4; i++) {
        controlPin[i] =  muxChannel[channel][i];
    }

    //read the value at the SIG pin
    float val = _SIG.read();

    //return the value
    return val;
}
