#include "mbed.h"
#include "SDFileSystem.h"
#include "Adafruit_ADS1015.h"
#include "BME280.h"
#include "CronoDot.h"


//Edit for fork
/////////////////////////////////////////////
//General Items
/////////////////////////////////////////////
I2C                 i2c(PB_9, PB_8);//(D14, D15); SDA,SCL
Serial              pc(USBTX, USBRX);
BME280              bmesensor(PB_9, PB_8);//(D14, D15);
CronoDot            RTC_UPAS(PB_9, PB_8);//(D14, D15);


/////////////////////////////////////////////
//Analog to Digital Converter
/////////////////////////////////////////////
 Adafruit_ADS1115    ads(&i2c);
Adafruit_ADS1115    ads2(&i2c);
//DigitalIn           ADS_ALRT(PA_10); //Connected but currently unused. (ADS1115) http://www.ti.com/lit/ds/symlink/ads1115.pdf



/////////////////////////////////////////////
//SD Card
/////////////////////////////////////////////
char filename[] = "/sd/SHARP_LOG00.txt";
SDFileSystem sd(D11, D12, D13, D10, "sd"); // (MOSI, MISO, SCK, SEL)
//DigitalIn     sdCD(PA_11, PullUp);


/////////////////////////////////////////////
//Callbacks
/////////////////////////////////////////////
Ticker          logg;     //This is the logging callback object


/////////////////////////////////////////////
//Varible Definitions
/////////////////////////////////////////////
uint16_t serial_num = 1;                // Default serial/calibration number
int RunReady =0;

bool ledOn = 0;

struct tm STtime;
char timestr[32];
char yrstr[4];
char mostr[4];
char daystr[4];
char hrstr[4];
char minstr[4];
char secstr[4];

int stYr, stMo, stDay, stHr, stMin, stSec;


float press;
float temp;
float rh;
float atmoRho; //g/L
int   logInerval = 2;//seconds

DigitalOut          sharp1LED(D7, 1);
DigitalOut          sharp2LED(D6, 1);
DigitalOut          sharp3LED(D5, 1);
DigitalOut          sharp4LED(D4, 1);
DigitalOut          sharp5LED(D3, 1);
DigitalOut          sharp6LED(D2, 1);

int samplingTime = 280;
int deltaTime = 40;
int sleepTime= 9680;
int sharp1, sharp2, sharp3, sharp4, sharp5, sharp6;
float sharpVolt1, sharpVolt2, sharpVolt3, sharpVolt4, sharpVolt5, sharpVolt6; //V




//////////////////////////////////////////////////////////////
//SD Logging Function
//////////////////////////////////////////////////////////////
void log_data()
{
    //Get RTC time(s)
    ///////////////////////////
    RTC_UPAS.get_time(); 
    time_t seconds = time(NULL);
    strftime(timestr, 32, "%y%m%d%H%M%S", localtime(&seconds));
/*
    strftime(yrstr, 4, "%y", localtime(&seconds));
    stYr = atoi(yrstr);
    
    strftime(mostr, 4, "%m", localtime(&seconds));
    stMo = atoi(mostr);
    
    strftime(daystr, 4, "%d", localtime(&seconds));
    stDay = atoi(daystr);
    
    strftime(hrstr, 4, "%H", localtime(&seconds));
    stHr = atoi(hrstr);
    
    strftime(minstr, 4, "%M", localtime(&seconds));
    stMin = atoi(minstr);
    
    strftime(secstr, 4, "%S", localtime(&seconds));
    stSec = atoi(secstr);
*/
    //pc.printf("%s,%s,%d,%s,%d,%s,%d,%s,%d,%s,%d,%s,%d\r\n", timestr,yrstr,stYr,mostr,stMo,daystr,stDay,hrstr,stHr,minstr,stMin,secstr,stSec);
    
    
    //Get Sensor Data except GPS
    ////////////////////////////
    press = bmesensor.getPressure();
    temp = bmesensor.getTemperature();
    rh = bmesensor.getHumidity();
    atmoRho = ((press-((6.1078*pow((float)10,(float)((7.5*temp)/(237.3+temp))))*(rh/100)))*100)/(287.0531*(temp+273.15))+((6.1078*pow((float)10,(float)((7.5*temp)/(237.3+temp))))*(rh/100)*100)/(461.4964*(temp+273.15));
    
    //pc.printf("%f,%f,%f,%f\r\n", temp, press, rh, atmoRho);
    
    sharp1LED = 0;
    wait_us(samplingTime);
    sharp1 = ads.readADC_SingleEnded(0, 0xC383); // read channel 1
    sharpVolt1 = (sharp1*4.096)/(32768*1);
    wait_us(deltaTime);
    sharp1LED = 1;
    wait_us(sleepTime);
    
     sharp2LED = 0;
    wait_us(samplingTime);
    sharp2 = ads.readADC_SingleEnded(1, 0xD383); // read channel 1
    sharpVolt2 = (sharp2*4.096)/(32768*1);
    wait_us(deltaTime);
    sharp2LED = 1;
    wait_us(sleepTime);
    
     sharp3LED = 0;
    wait_us(samplingTime);
    sharp3 = ads.readADC_SingleEnded(2, 0xE383); // read channel 1
    sharpVolt3 = (sharp3*4.096)/(32768*1);
    wait_us(deltaTime);
    sharp3LED = 1;
    wait_us(sleepTime);
    
     sharp4LED = 0;
    wait_us(samplingTime);
    sharp4 = ads.readADC_SingleEnded(3, 0xF383); // read channel 1
    sharpVolt4 = (sharp4*4.096)/(32768*1);
    wait_us(deltaTime);
    sharp4LED = 1;
    wait_us(sleepTime);
    
    sharp5LED = 0;
    wait_us(samplingTime);
    sharp5 = ads2.readADC_SingleEnded(0, 0xC383); // read channel 1
    sharpVolt5 = (sharp1*4.096)/(32768*1);
    sharp5LED = 1;
    wait_us(sleepTime);
    
    sharp6LED = 0;
    wait_us(samplingTime);
    sharp6 = ads2.readADC_SingleEnded(0, 0xD383); // read channel 1
    sharpVolt6 = (sharp1*4.096)/(32768*1);
    sharp6LED = 1;
    wait_us(sleepTime);
    
    
    

    
    
    
   //pc.printf("%d,%f,%d,%f,\r\n" ,sharp5,sharpVolt5, sharp6, sharpVolt6);
  pc.printf("%d,%d\r\n",sharp1, sharp4);
   //pc.printf("%d,%f,%d,%f,%d,%f,%d,%f\r\n" ,sharp1,sharpVolt1, sharp2, sharpVolt2,sharp3,sharpVolt3, sharp4, sharpVolt4);
    //pc.printf("%2.2f,%4.2f,%2.1f,%1.3f\r\n", temp,press,rh,atmoRho);
    //pc.printf("%d,%f,%d,%f\r\n" ,sharp3,sharpVolt3, sharp4, sharpVolt4);

    FILE *fp = fopen(filename, "scotttrial");
   fprintf(fp, "%02d,%02d,%02d,%02d,%02d,%02d,",RTC_UPAS.year, RTC_UPAS.month,RTC_UPAS.date,RTC_UPAS.hour,RTC_UPAS.minutes,RTC_UPAS.seconds);
    fprintf(fp, "%s,", timestr);
    fprintf(fp, "%2.2f,%4.2f,%2.1f,%1.3f", temp,press,rh,atmoRho);
    fprintf(fp, "%d,%f,%d,%f," ,sharp1,sharpVolt1, sharp2, sharpVolt2);
    fprintf(fp, "%d,%f,%d,%f" ,sharp3,sharpVolt3, sharp4, sharpVolt4);
    fprintf(fp, "%d,%f,%d,%f,\r\n" ,sharp5,sharpVolt5, sharp6, sharpVolt6);
       fclose(fp);
    free(fp);
    





}


//////////////////////////////////////////////////////////////
//Main Function
//////////////////////////////////////////////////////////////
int main(){
    
  
 
    pc.baud(115200);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------Startup-------------\n\r");
    wait(0.5);
    

     RTC_UPAS.set_time(0,0,0,1,1,1,16);//sets chronodot RTC
     
    ///////////////////////
    //sets ST RTC
    //////////////////////
    STtime.tm_sec = 0;    // 0-59
    STtime.tm_min = 0;    // 0-59
    STtime.tm_hour = 0;   // 0-23
    STtime.tm_mday = 1;   // 1-31
    STtime.tm_mon = 0;     // 0-11
    STtime.tm_year = 116;  // year since 1900 (116 = 2016)
    time_t STseconds = mktime(&STtime);
    set_time(STseconds); // Set RTC time

                        
    RTC_UPAS.get_time(); 
    
    
    time_t seconds = time(NULL);
    strftime(timestr, 32, "%y-%m-%d-%H=%M=%S", localtime(&seconds));
    
    strftime(yrstr, 4, "%y", localtime(&seconds));
    stYr = atoi(yrstr);
    
    strftime(mostr, 4, "%m", localtime(&seconds));
    stMo = atoi(mostr);
    
    strftime(daystr, 4, "%d", localtime(&seconds));
    stDay = atoi(daystr);
    
    strftime(hrstr, 4, "%H", localtime(&seconds));
    stHr = atoi(hrstr);
    
    strftime(minstr, 4, "%M", localtime(&seconds));
    stMin = atoi(minstr);
    
    strftime(secstr, 4, "%S", localtime(&seconds));
    stSec = atoi(secstr);
    
    
    
    
  // sprintf(filename,"/sd/SHARP_LOG00.txt");
      
      for (uint8_t i = 0; i < 100; i++) {
        filename[13] = i/10 + '0';
        filename[14] = i%10 + '0';
        FILE *fp = fopen(filename, "r");
        if (fp == NULL) {
        // only open a new file if it doesn't exist
        FILE *fp = fopen(filename, "w");
        fclose(fp);
        break;  // leave the loop!
        } 
       }
    


        while(fmod((double)stSec,10)!=0) {
           //pc.printf("%f, %f\r\n", floor(secondsD), floor(lastsecondD)); 
            time_t seconds = time(NULL);
            strftime(secstr, 4, "%S", localtime(&seconds));
            stSec = atoi(secstr);
            wait_ms(100);
        }
        
    logg.attach(&log_data, 3);
    



    //** end of initalization **//
    //---------------------------------------------------------------------------------------------//
    //---------------------------------------------------------------------------------------------//
    // Main Control Loop

    while (1) {
        // Do other things...
        
        }
    



}
