#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"


#define CHANNELON   0
#define CHANNELOFF  1
#define LCDLEN      10
#define DATATIME    0.1
//LCD messages



// Operating parameters
#define SIDETONE    700.0   
#define TONEMIN     200.0
#define TONEINT     800.00 // So tone max is 1000
#define TONEON      0.50
#define TONEOFF     0.0
#define SPEEDAST    0
#define TONEAST     1

SLCD slcd; //define LCD display

TSISensor tsiScaling; // Capacitive sensor/slider

PwmOut led(LED_RED);
DigitalOut outPin(PTC9); //J1-16
PwmOut soundOut(PTA13);
// Global scalars
char lcdData[LCDLEN];

float tonePeriod;
float toneFreq = SIDETONE;



void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 
  
void toneAdjust( float scaling) {
    int tempInt;
    
    toneFreq = TONEMIN + scaling * TONEINT;
    tonePeriod = 1.0/toneFreq;  
    soundOut.period(tonePeriod); // adusting period
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
    return;
}
void lightAdjust( float scaling) { // Control brightness of LED
    float tempDutyFactor;
    
    tempDutyFactor = 1.0 - scaling; //LED is a sinking connection 
                                    // anode is held at 5V
    led.write(tempDutyFactor); //sdjusting duty factor
    return;
}
int main(){
    int tempInt;
    float tempValue;
    tonePeriod = 1.0/toneFreq; 
    soundOut.period(tonePeriod);
    
    
    
    led.write(CHANNELON);
    outPin.write(CHANNELOFF);
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
    wait(DATATIME);   
    while (true) {
    
        tempValue = tsiScaling.readPercentage();
        if(tempValue > 0) {
            soundOut.write(TONEON); // set duty factor to 505
            toneAdjust( tempValue);
            lightAdjust(tempValue);
        } else { 
            soundOut.write(TONEOFF); // set dutyfactor to 0%
            LCDMessNoDwell("SOFF");
        }       
        wait(DATATIME);                  
    } // while forever
}// end main